/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xmlgraphics.image.loader.util;

import java.io.IOException;
import java.io.InputStream;
import javax.imageio.stream.ImageInputStream;

public class ImageInputStreamAdapter
extends InputStream {
    private ImageInputStream iin;
    private long lastMarkPosition;

    public ImageInputStreamAdapter(ImageInputStream iin) {
        this.iin = iin;
    }

    public int read(byte[] b, int off, int len) throws IOException {
        return this.iin.read(b, off, len);
    }

    public int read(byte[] b) throws IOException {
        return this.iin.read(b);
    }

    public int read() throws IOException {
        return this.iin.read();
    }

    public long skip(long n) throws IOException {
        return this.iin.skipBytes(n);
    }

    public void close() throws IOException {
        this.iin.close();
        this.iin = null;
    }

    public synchronized void mark(int readlimit) {
        try {
            this.lastMarkPosition = this.iin.getStreamPosition();
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unexpected IOException in ImageInputStream.getStreamPosition()", ioe);
        }
    }

    public boolean markSupported() {
        return true;
    }

    public synchronized void reset() throws IOException {
        this.iin.seek(this.lastMarkPosition);
    }

    public int available() throws IOException {
        return 0;
    }
}

