/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HeaderParser {
    public static List<HeaderElement> parseHeader(String header) {
        ArrayList<HeaderElement> elements = new ArrayList<HeaderElement>();
        if (header == null || header.trim().length() == 0) {
            return elements;
        }
        List<String> clauses = HeaderParser.parseDelimitedString(header, ",", false);
        for (String clause : clauses) {
            String[] tokens = clause.split(";");
            if (tokens.length < 1) {
                throw new IllegalArgumentException("Invalid header clause: " + clause);
            }
            HeaderElement elem = new HeaderElement(tokens[0].trim());
            elements.add(elem);
            for (int i = 1; i < tokens.length; ++i) {
                int pos = tokens[i].indexOf(61);
                if (pos != -1) {
                    String value;
                    String name;
                    if (pos > 0 && tokens[i].charAt(pos - 1) == ':') {
                        name = tokens[i].substring(0, pos - 1).trim();
                        value = tokens[i].substring(pos + 1).trim();
                        elem.addDirective(name, value);
                        continue;
                    }
                    name = tokens[i].substring(0, pos).trim();
                    value = tokens[i].substring(pos + 1).trim();
                    elem.addAttribute(name, value);
                    continue;
                }
                elem = new HeaderElement(tokens[i].trim());
                elements.add(elem);
            }
        }
        return elements;
    }

    private static List<String> parseDelimitedString(String value, String delim, boolean includeQuotes) {
        if (value == null) {
            value = "";
        }
        ArrayList<String> list = new ArrayList<String>();
        int CHAR = 1;
        int DELIMITER = 2;
        int STARTQUOTE = 4;
        int ENDQUOTE = 8;
        StringBuffer sb = new StringBuffer();
        int expecting = CHAR | DELIMITER | STARTQUOTE;
        for (int i = 0; i < value.length(); ++i) {
            boolean isQuote;
            char c = value.charAt(i);
            boolean isDelimiter = delim.indexOf(c) >= 0;
            boolean bl = isQuote = c == '\"';
            if (isDelimiter && (expecting & DELIMITER) > 0) {
                list.add(sb.toString().trim());
                sb.delete(0, sb.length());
                expecting = CHAR | DELIMITER | STARTQUOTE;
                continue;
            }
            if (isQuote && (expecting & STARTQUOTE) > 0) {
                if (includeQuotes) {
                    sb.append(c);
                }
                expecting = CHAR | ENDQUOTE;
                continue;
            }
            if (isQuote && (expecting & ENDQUOTE) > 0) {
                if (includeQuotes) {
                    sb.append(c);
                }
                expecting = CHAR | STARTQUOTE | DELIMITER;
                continue;
            }
            if ((expecting & CHAR) > 0) {
                sb.append(c);
                continue;
            }
            throw new IllegalArgumentException("Invalid delimited string: " + value);
        }
        if (sb.length() > 0) {
            list.add(sb.toString().trim());
        }
        return list;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class HeaderElement {
        private String path;
        private Map<String, String> attributes;
        private Map<String, String> directives;

        public HeaderElement(String path) {
            this.path = path;
            this.attributes = new HashMap<String, String>();
            this.directives = new HashMap<String, String>();
        }

        public String getName() {
            return this.path;
        }

        public Map<String, String> getAttributes() {
            return this.attributes;
        }

        public String getAttribute(String name) {
            return this.attributes.get(name);
        }

        public void addAttribute(String name, String value) {
            this.attributes.put(name, value);
        }

        public Map<String, String> getDirectives() {
            return this.directives;
        }

        public String getDirective(String name) {
            return this.directives.get(name);
        }

        public void addDirective(String name, String value) {
            this.directives.put(name, value);
        }
    }
}

