/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.osgi.bundle.util;

import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.xbean.osgi.bundle.util.BundleUtils;
import org.apache.xbean.osgi.bundle.util.DelegatingBundle;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BundleClassLoader
extends ClassLoader
implements BundleReference {
    private static final String META_INF_1 = "META-INF/";
    private static final String META_INF_2 = "/META-INF/";
    private final Bundle bundle;
    private boolean searchWiredBundles;

    public BundleClassLoader(Bundle bundle) {
        this(bundle, true);
    }

    public BundleClassLoader(Bundle bundle, boolean searchWiredBundles) {
        this.bundle = bundle;
        this.searchWiredBundles = searchWiredBundles;
    }

    @Override
    public Class<?> loadClass(String name) throws ClassNotFoundException {
        return this.loadClass(name, false);
    }

    @Override
    protected Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        Class clazz = this.bundle.loadClass(name);
        if (resolve) {
            this.resolveClass(clazz);
        }
        return clazz;
    }

    public String toString() {
        return "[BundleClassLoader] " + this.bundle;
    }

    @Override
    public URL getResource(String name) {
        URL resource = this.bundle.getResource(name);
        if (resource == null && this.isMetaInfResource(name)) {
            LinkedHashSet<Bundle> wiredBundles = BundleUtils.getWiredBundles(this.bundle);
            Iterator iterator = wiredBundles.iterator();
            while (iterator.hasNext() && resource == null) {
                resource = ((Bundle)iterator.next()).getResource(name);
            }
        }
        return resource;
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        Enumeration e = this.bundle.getResources(name);
        if (this.isMetaInfResource(name)) {
            ArrayList<URL> allResources = new ArrayList<URL>();
            this.addToList(allResources, e);
            LinkedHashSet<Bundle> wiredBundles = BundleUtils.getWiredBundles(this.bundle);
            for (Bundle wiredBundle : wiredBundles) {
                Enumeration resources = wiredBundle.getResources(name);
                this.addToList(allResources, resources);
            }
            return Collections.enumeration(allResources);
        }
        if (e == null) {
            return Collections.enumeration(Collections.EMPTY_LIST);
        }
        return e;
    }

    public void setSearchWiredBundles(boolean search) {
        this.searchWiredBundles = search;
    }

    public boolean getSearchWiredBundles() {
        return this.searchWiredBundles;
    }

    private boolean isMetaInfResource(String name) {
        return this.searchWiredBundles && name != null && (name.startsWith(META_INF_1) || name.startsWith(META_INF_2));
    }

    private void addToList(List<URL> list, Enumeration<URL> enumeration) {
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                list.add(enumeration.nextElement());
            }
        }
    }

    public Bundle getBundle(boolean unwrap) {
        if (unwrap && this.bundle instanceof DelegatingBundle) {
            return ((DelegatingBundle)this.bundle).getMainBundle();
        }
        return this.bundle;
    }

    public Bundle getBundle() {
        return this.getBundle(true);
    }

    public int hashCode() {
        return this.bundle.hashCode();
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other == null || !other.getClass().equals(this.getClass())) {
            return false;
        }
        BundleClassLoader otherBundleClassLoader = (BundleClassLoader)other;
        return this.bundle == otherBundleClassLoader.bundle;
    }
}

