/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xbean.finder;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.JarURLConnection;
import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarInputStream;
import org.apache.xbean.finder.AbstractFinder;
import org.apache.xbean.finder.UrlSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ClassFinder
extends AbstractFinder {
    private final ClassLoader classLoader;

    public ClassFinder(ClassLoader classLoader) throws Exception {
        this(classLoader, true);
    }

    public ClassFinder(ClassLoader classLoader, boolean excludeParent) throws Exception {
        this(classLoader, ClassFinder.getUrls(classLoader, excludeParent));
    }

    public ClassFinder(ClassLoader classLoader, ClassLoader exclude) throws Exception {
        this(classLoader, ClassFinder.getUrls(classLoader, exclude));
    }

    public ClassFinder(ClassLoader classLoader, URL url) {
        this(classLoader, Arrays.asList(url));
    }

    public ClassFinder(ClassLoader classLoader, Collection<URL> urls) {
        this.classLoader = classLoader;
        ArrayList<String> classNames = new ArrayList<String>();
        for (URL location : urls) {
            try {
                if (location.getProtocol().equals("jar")) {
                    classNames.addAll(this.jar(location));
                    continue;
                }
                if (!location.getProtocol().equals("file")) continue;
                try {
                    URL jarUrl = new URL("jar", "", location.toExternalForm() + "!/");
                    JarURLConnection juc = (JarURLConnection)jarUrl.openConnection();
                    juc.getJarFile();
                    classNames.addAll(this.jar(jarUrl));
                }
                catch (IOException e) {
                    classNames.addAll(this.file(location));
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (String className : classNames) {
            this.readClassDef(className);
        }
    }

    public ClassFinder(Class ... classes) {
        this(Arrays.asList(classes));
    }

    public ClassFinder(List<Class> classes) {
        this.classLoader = null;
        ArrayList<AbstractFinder.Annotatable> infos = new ArrayList<AbstractFinder.Annotatable>();
        ArrayList<Package> packages = new ArrayList<Package>();
        for (Class clazz : classes) {
            try {
                Package aPackage = clazz.getPackage();
                if (aPackage != null && !packages.contains(aPackage)) {
                    infos.add((AbstractFinder)this.new AbstractFinder.PackageInfo(aPackage));
                    packages.add(aPackage);
                }
                AbstractFinder.ClassInfo classInfo = (AbstractFinder)this.new AbstractFinder.ClassInfo(clazz);
                infos.add(classInfo);
                this.classInfos.add(classInfo);
                for (Method method : clazz.getDeclaredMethods()) {
                    infos.add((AbstractFinder)this.new AbstractFinder.MethodInfo(classInfo, method));
                }
                for (Executable executable : clazz.getConstructors()) {
                    infos.add((AbstractFinder)this.new AbstractFinder.MethodInfo(classInfo, (Constructor)executable));
                }
                for (AccessibleObject accessibleObject : clazz.getDeclaredFields()) {
                    infos.add(new AbstractFinder.FieldInfo(classInfo, (Field)accessibleObject));
                }
            }
            catch (NoClassDefFoundError e) {
                throw new NoClassDefFoundError("Could not fully load class: " + clazz.getName() + "\n due to:" + e.getMessage() + "\n in classLoader: \n" + clazz.getClassLoader());
            }
        }
        for (AbstractFinder.Info info : infos) {
            for (AbstractFinder.AnnotationInfo annotation : info.getAnnotations()) {
                List<AbstractFinder.Info> annotationInfos = this.getAnnotationInfos(annotation.getName());
                annotationInfos.add(info);
            }
        }
    }

    private static Collection<URL> getUrls(ClassLoader classLoader, boolean excludeParent) throws IOException {
        return ClassFinder.getUrls(classLoader, excludeParent ? classLoader.getParent() : null);
    }

    private static Collection<URL> getUrls(ClassLoader classLoader, ClassLoader excludeParent) throws IOException {
        UrlSet urlSet = new UrlSet(classLoader);
        if (excludeParent != null) {
            urlSet = urlSet.exclude(excludeParent);
        }
        return urlSet.getUrls();
    }

    @Override
    protected URL getResource(String className) {
        return this.classLoader.getResource(className);
    }

    @Override
    protected Class<?> loadClass(String fixedName) throws ClassNotFoundException {
        return this.classLoader.loadClass(fixedName);
    }

    private List<String> file(URL location) {
        ArrayList<String> classNames = new ArrayList<String>();
        File dir = new File(URLDecoder.decode(location.getPath()));
        if (dir.getName().equals("META-INF")) {
            dir = dir.getParentFile();
        }
        if (dir.isDirectory()) {
            this.scanDir(dir, classNames, "");
        }
        return classNames;
    }

    private void scanDir(File dir, List<String> classNames, String packageName) {
        File[] files;
        for (File file : files = dir.listFiles()) {
            if (file.isDirectory()) {
                this.scanDir(file, classNames, packageName + file.getName() + ".");
                continue;
            }
            if (!file.getName().endsWith(".class")) continue;
            String name = file.getName();
            if ((name = name.replaceFirst(".class$", "")).contains(".")) continue;
            classNames.add(packageName + name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> jar(URL location) throws IOException {
        String jarPath = location.getFile();
        if (jarPath.indexOf("!") > -1) {
            jarPath = jarPath.substring(0, jarPath.indexOf("!"));
        }
        URL url = new URL(jarPath);
        InputStream in = url.openStream();
        try {
            JarInputStream jarStream = new JarInputStream(in);
            List<String> list = this.jar(jarStream);
            return list;
        }
        finally {
            in.close();
        }
    }

    private List<String> jar(JarInputStream jarStream) throws IOException {
        JarEntry entry;
        ArrayList<String> classNames = new ArrayList<String>();
        while ((entry = jarStream.getNextJarEntry()) != null) {
            if (entry.isDirectory() || !entry.getName().endsWith(".class")) continue;
            String className = entry.getName();
            if ((className = className.replaceFirst(".class$", "")).contains(".")) continue;
            className = className.replace('/', '.');
            classNames.add(className);
        }
        return classNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readClassDef(String className) {
        block7: {
            if (!className.endsWith(".class")) {
                className = className.replace('.', '/') + ".class";
            }
            try {
                URL resource = this.getResource(className);
                if (resource != null) {
                    InputStream in = resource.openStream();
                    try {
                        this.readClassDef(in);
                        break block7;
                    }
                    finally {
                        in.close();
                    }
                }
                new Exception("Could not load " + className).printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

