/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security.spnego;

import java.security.Principal;
import java.util.Set;
import javax.security.auth.Subject;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.login.LoginContext;
import javax.security.auth.login.LoginException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.ws.security.WSSecurityException;
import org.apache.ws.security.spnego.SpnegoClientAction;
import org.apache.ws.security.spnego.SpnegoServiceAction;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.MessageProp;

public class SpnegoTokenContext {
    private static final Log LOG = LogFactory.getLog(SpnegoTokenContext.class);
    private GSSContext secContext;
    private byte[] token;
    private boolean mutualAuth;

    public void retrieveServiceTicket(String jaasLoginModuleName, CallbackHandler callbackHandler, String serviceName) throws WSSecurityException {
        Subject clientSubject;
        Set<Principal> clientPrincipals;
        LoginContext loginContext = null;
        try {
            loginContext = callbackHandler == null ? new LoginContext(jaasLoginModuleName) : new LoginContext(jaasLoginModuleName, callbackHandler);
            loginContext.login();
        }
        catch (LoginException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{ex.getMessage()});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Successfully authenticated to the TGT");
        }
        if ((clientPrincipals = (clientSubject = loginContext.getSubject()).getPrincipals()).isEmpty()) {
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{"No Client principals found after login"});
        }
        SpnegoClientAction action = new SpnegoClientAction(serviceName);
        action.setMutualAuth(this.mutualAuth);
        this.token = Subject.doAs(clientSubject, action);
        if (this.token == null) {
            throw new WSSecurityException(0, "kerberosServiceTicketError");
        }
        this.secContext = action.getContext();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Successfully retrieved a service ticket");
        }
    }

    public void validateServiceTicket(String jaasLoginModuleName, CallbackHandler callbackHandler, String serviceName, byte[] ticket) throws WSSecurityException {
        LoginContext loginContext = null;
        try {
            loginContext = callbackHandler == null ? new LoginContext(jaasLoginModuleName) : new LoginContext(jaasLoginModuleName, callbackHandler);
            loginContext.login();
        }
        catch (LoginException ex) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)ex.getMessage(), (Throwable)ex);
            }
            throw new WSSecurityException(0, "kerberosLoginError", new Object[]{ex.getMessage()});
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Successfully authenticated to the TGT");
        }
        Subject subject = loginContext.getSubject();
        String service = serviceName;
        if (service == null) {
            Set<Principal> principals = subject.getPrincipals();
            if (principals.isEmpty()) {
                throw new WSSecurityException(0, "kerberosLoginError", new Object[]{"No Client principals found after login"});
            }
            service = principals.iterator().next().getName();
        }
        SpnegoServiceAction action = new SpnegoServiceAction(ticket, service);
        this.token = Subject.doAs(subject, action);
        this.secContext = action.getContext();
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)"Successfully validated a service ticket");
        }
    }

    public void setMutualAuth(boolean mutualAuthentication) {
        this.mutualAuth = mutualAuthentication;
    }

    public byte[] getToken() {
        return this.token;
    }

    public boolean isEstablished() {
        if (this.secContext == null) {
            return false;
        }
        return this.secContext.isEstablished();
    }

    public byte[] unwrapKey(byte[] secret) throws WSSecurityException {
        MessageProp mProp = new MessageProp(0, true);
        try {
            return this.secContext.unwrap(secret, 0, secret.length, mProp);
        }
        catch (GSSException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error in cleaning up a GSS context", (Throwable)e);
            }
            throw new WSSecurityException(0, "spnegoKeyError");
        }
    }

    public byte[] wrapKey(byte[] secret) throws WSSecurityException {
        MessageProp mProp = new MessageProp(0, true);
        try {
            return this.secContext.wrap(secret, 0, secret.length, mProp);
        }
        catch (GSSException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Error in cleaning up a GSS context", (Throwable)e);
            }
            throw new WSSecurityException(0, "spnegoKeyError");
        }
    }

    public void clear() {
        block2: {
            this.token = null;
            this.mutualAuth = false;
            try {
                this.secContext.dispose();
            }
            catch (GSSException e) {
                if (!LOG.isDebugEnabled()) break block2;
                LOG.debug((Object)"Error in cleaning up a GSS context", (Throwable)e);
            }
        }
    }
}

