/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMContainer;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.OMNodeEx;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.om.util.StAXUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public abstract class ChildNode
extends NodeImpl {
    protected ChildNode previousSibling;
    protected ChildNode nextSibling;
    private ParentNode ownerNode;

    protected ChildNode(DocumentImpl ownerDocument, OMFactory factory) {
        super(factory);
        this.setOwnerDocument(ownerDocument);
    }

    protected ChildNode(OMFactory factory) {
        super(factory);
    }

    DocumentImpl ownerDocument() {
        if (this.ownerNode == null) {
            return null;
        }
        if (this.ownerNode instanceof DocumentImpl) {
            return (DocumentImpl)this.ownerNode;
        }
        return this.ownerNode.ownerDocument();
    }

    void setOwnerDocument(DocumentImpl document) {
        if (this.hasParent()) {
            throw new IllegalStateException();
        }
        this.ownerNode = document;
    }

    public Document getOwnerDocument() {
        return this.ownerDocument();
    }

    ParentNode parentNode() {
        return this.hasParent() ? this.ownerNode : null;
    }

    public OMNode getNextOMSibling() throws OMException {
        ParentNode parentNode = this.parentNode();
        while (this.nextSibling == null && parentNode != null && !parentNode.done && parentNode.builder != null) {
            parentNode.buildNext();
        }
        return (OMNode)this.nextSibling;
    }

    public OMNode getNextOMSiblingIfAvailable() {
        return (OMNode)this.nextSibling;
    }

    public Node getNextSibling() {
        return (Node)this.getNextOMSibling();
    }

    public OMNode getPreviousOMSibling() {
        return (OMNode)this.previousSibling;
    }

    public Node getPreviousSibling() {
        return this.previousSibling;
    }

    public void setNextOMSibling(OMNode node) {
        if (node == null) {
            this.nextSibling = null;
            return;
        }
        if (!(node instanceof ChildNode)) {
            throw new OMException("The node is not a " + ChildNode.class);
        }
        this.nextSibling = (ChildNode)node;
    }

    public void setPreviousOMSibling(OMNode node) {
        if (node == null) {
            this.previousSibling = null;
            return;
        }
        if (!(node instanceof ChildNode)) {
            throw new OMException("The node is not a " + ChildNode.class);
        }
        this.previousSibling = (ChildNode)node;
    }

    public OMContainer getParent() throws OMException {
        return this.parentNode();
    }

    public Node getParentNode() {
        return this.parentNode();
    }

    public void setParent(OMContainer element) {
        if (element == null) {
            this.ownerNode = this.ownerDocument();
            this.hasParent(false);
        } else if (element instanceof ParentNode) {
            this.ownerNode = (ParentNode)element;
            this.hasParent(true);
        } else {
            throw new OMException("The given parent is not of the type " + ParentNode.class);
        }
    }

    public OMNode detach() throws OMException {
        ParentNode parentNode = this.parentNode();
        if (parentNode == null) {
            throw new OMException("Parent level elements cannot be detached");
        }
        if (!this.done) {
            this.build();
        }
        this.getNextOMSibling();
        if (this.previousSibling == null) {
            if (this.nextSibling != null) {
                parentNode.setFirstChild((OMNode)this.nextSibling);
            } else {
                parentNode.firstChild = null;
                parentNode.lastChild = null;
            }
        } else {
            this.previousSibling.setNextOMSibling((OMNode)this.nextSibling);
            if (this.nextSibling == null) {
                this.previousSibling.parentNode().done = true;
            }
        }
        if (this.nextSibling != null) {
            this.nextSibling.setPreviousOMSibling((OMNode)this.previousSibling);
            this.nextSibling = null;
        }
        if (parentNode != null && parentNode.lastChild == this) {
            parentNode.lastChild = this.previousSibling;
        }
        this.setParent(null);
        this.previousSibling = null;
        return (OMNode)this;
    }

    public void discard() throws OMException {
        throw new UnsupportedOperationException("Cannot discard this node");
    }

    public void insertSiblingAfter(OMNode sibling) throws OMException {
        ChildNode domSibling;
        ParentNode parentNode = this.parentNode();
        if (parentNode == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        ((OMNodeEx)sibling).setParent((OMContainer)parentNode);
        if (sibling instanceof ChildNode) {
            domSibling = (ChildNode)sibling;
            domSibling.previousSibling = this;
            if (this.nextSibling == null) {
                parentNode.setLastChild(sibling);
            } else {
                this.nextSibling.previousSibling = domSibling;
            }
        } else {
            throw new OMException("The given child is not of type " + ChildNode.class);
        }
        domSibling.nextSibling = this.nextSibling;
        this.nextSibling = domSibling;
    }

    public void insertSiblingBefore(OMNode sibling) throws OMException {
        ChildNode siblingImpl;
        ParentNode parentNode = this.parentNode();
        if (parentNode == null) {
            throw new OMException("Parent can not be null");
        }
        if (this == sibling) {
            throw new OMException("Inserting self as the sibling is not allowed");
        }
        if (sibling instanceof ChildNode) {
            siblingImpl = (ChildNode)sibling;
            siblingImpl.nextSibling = this;
            if (this.previousSibling == null) {
                parentNode.setFirstChild((OMNode)siblingImpl);
                siblingImpl.previousSibling = null;
            } else {
                siblingImpl.setParent((OMContainer)parentNode);
                this.previousSibling.setNextOMSibling((OMNode)siblingImpl);
                siblingImpl.setPreviousOMSibling((OMNode)this.previousSibling);
            }
        } else {
            throw new OMException("The given child is not of type " + ChildNode.class);
        }
        this.previousSibling = siblingImpl;
    }

    public Node cloneNode(boolean deep) {
        ChildNode newnode = (ChildNode)super.cloneNode(deep);
        newnode.previousSibling = null;
        newnode.nextSibling = null;
        newnode.isFirstChild(false);
        newnode.ownerNode = this.ownerDocument();
        newnode.hasParent(false);
        return newnode;
    }

    public void setComplete(boolean state) {
        this.done = state;
        ParentNode parentNode = this.parentNode();
        if (parentNode != null) {
            if (!this.done) {
                parentNode.setComplete(false);
            } else {
                parentNode.notifyChildComplete();
            }
        }
    }

    public boolean isComplete() {
        return this.done;
    }

    public void build() {
        while (!this.done) {
            this.builder.next();
        }
    }

    public void buildWithAttachments() {
        if (!this.done) {
            this.build();
        }
    }

    public void close(boolean build) {
        if (build) {
            this.build();
        }
        this.done = true;
        if (this.builder instanceof StAXBuilder && !((StAXBuilder)this.builder).isClosed()) {
            ((StAXBuilder)this.builder).releaseParserOnClose(true);
            ((StAXBuilder)this.builder).close();
        }
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, true);
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, false);
    }

    public void serialize(XMLStreamWriter xmlWriter, boolean cache) throws XMLStreamException {
        MTOMXMLStreamWriter writer = xmlWriter instanceof MTOMXMLStreamWriter ? (MTOMXMLStreamWriter)xmlWriter : new MTOMXMLStreamWriter(xmlWriter);
        this.internalSerialize((XMLStreamWriter)writer, cache);
        writer.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(OutputStream output) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((OutputStream)output);
        try {
            this.serialize(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Writer writer) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        try {
            this.serialize(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((OutputStream)output);
        try {
            this.serializeAndConsume(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        try {
            this.serializeAndConsume(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format, true);
        try {
            this.internalSerialize((XMLStreamWriter)writer, true);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serialize(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writer2));
        writer.setOutputFormat(format);
        try {
            this.internalSerialize((XMLStreamWriter)writer, true);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format, false);
        try {
            this.internalSerialize((XMLStreamWriter)writer, false);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serializeAndConsume(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writer2));
        try {
            writer.setOutputFormat(format);
            this.internalSerialize((XMLStreamWriter)writer, false);
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public void internalSerialize(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, true);
    }

    public void internalSerializeAndConsume(XMLStreamWriter writer) throws XMLStreamException {
        this.internalSerialize(writer, false);
    }

    public abstract void internalSerialize(XMLStreamWriter var1, boolean var2) throws XMLStreamException;
}

