/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMMetaFactory;
import org.apache.axiom.soap.SOAPFactory;

public class OMAbstractFactory {
    public static final String META_FACTORY_NAME_PROPERTY = "org.apache.axiom.om.OMMetaFactory";
    private static final String DEFAULT_META_FACTORY_CLASS_NAME = "org.apache.axiom.om.impl.llom.factory.OMLinkedListMetaFactory";
    private static OMMetaFactory defaultMetaFactory;
    private static OMMetaFactory metaFactory;

    private OMAbstractFactory() {
    }

    public static void setMetaFactory(OMMetaFactory newMetaFactory) {
        metaFactory = newMetaFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static OMMetaFactory getMetaFactory() {
        String metaFactoryClassName;
        block17: {
            if (metaFactory != null) {
                return metaFactory;
            }
            if (defaultMetaFactory != null) {
                return defaultMetaFactory;
            }
            metaFactoryClassName = null;
            try {
                metaFactoryClassName = System.getProperty(META_FACTORY_NAME_PROPERTY);
                if ("".equals(metaFactoryClassName)) {
                    metaFactoryClassName = null;
                }
            }
            catch (SecurityException e) {
                // empty catch block
            }
            if (metaFactoryClassName == null) {
                try {
                    InputStream in = OMAbstractFactory.class.getResourceAsStream("/META-INF/services/" + OMMetaFactory.class.getName());
                    if (in == null) break block17;
                    try {
                        String line;
                        BufferedReader r = new BufferedReader(new InputStreamReader(in));
                        while ((line = r.readLine()) != null) {
                            if ((line = line.trim()).length() <= 0 || line.startsWith("#")) continue;
                            metaFactoryClassName = line;
                            break;
                        }
                    }
                    finally {
                        in.close();
                    }
                }
                catch (IOException ex) {
                    // empty catch block
                }
            }
        }
        if (metaFactoryClassName == null) {
            metaFactoryClassName = DEFAULT_META_FACTORY_CLASS_NAME;
        }
        try {
            defaultMetaFactory = (OMMetaFactory)Class.forName(metaFactoryClassName).newInstance();
        }
        catch (InstantiationException e) {
            throw new OMException(e);
        }
        catch (IllegalAccessException e) {
            throw new OMException(e);
        }
        catch (ClassNotFoundException e) {
            throw new OMException(e);
        }
        return defaultMetaFactory;
    }

    public static OMFactory getOMFactory() {
        return OMAbstractFactory.getMetaFactory().getOMFactory();
    }

    public static SOAPFactory getSOAP11Factory() {
        return OMAbstractFactory.getMetaFactory().getSOAP11Factory();
    }

    public static SOAPFactory getSOAP12Factory() {
        return OMAbstractFactory.getMetaFactory().getSOAP12Factory();
    }
}

