/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wink.common.internal.registry.metadata;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import java.lang.reflect.Type;
import javax.ws.rs.core.Application;
import org.apache.wink.common.internal.registry.Injectable;
import org.apache.wink.common.internal.registry.InjectableFactory;
import org.apache.wink.common.internal.registry.metadata.AbstractMetadataCollector;
import org.apache.wink.common.internal.registry.metadata.ClassMetadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ApplicationMetadataCollector
extends AbstractMetadataCollector {
    private static final Logger logger = LoggerFactory.getLogger(ApplicationMetadataCollector.class);

    private ApplicationMetadataCollector(Class<?> clazz) {
        super(clazz);
    }

    public static ClassMetadata collectMetadata(Class<?> clazz) {
        ApplicationMetadataCollector collector = new ApplicationMetadataCollector(clazz);
        collector.parseFields();
        collector.parseConstructors();
        return collector.getMetadata();
    }

    @Override
    protected final Injectable parseAccessibleObject(AccessibleObject field, Type fieldType) {
        Injectable injectable = InjectableFactory.getInstance().create(fieldType, field.getAnnotations(), (Member)((Object)field), this.getMetadata().isEncoded(), null);
        if (injectable.getParamType() == Injectable.ParamType.ENTITY) {
            return null;
        }
        return injectable;
    }

    @Override
    protected final boolean isConstructorParameterValid(Injectable fp) {
        return fp.getParamType() != Injectable.ParamType.ENTITY;
    }

    public static boolean isApplication(Class cls) {
        return Application.class.isAssignableFrom(cls);
    }
}

