/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.wizard;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.extensions.wizard.IWizardModel;
import org.apache.wicket.extensions.wizard.IWizardModelListener;
import org.apache.wicket.extensions.wizard.IWizardStep;

public abstract class AbstractWizardModel
implements IWizardModel {
    private static final long serialVersionUID = 1L;
    private boolean cancelVisible = true;
    private boolean lastVisible = false;
    private final List wizardModelListeners = new ArrayList(1);

    public final void addListener(IWizardModelListener listener) {
        this.wizardModelListeners.add(listener);
    }

    public void cancel() {
        this.fireWizardCancelled();
    }

    public void finish() {
        this.fireWizardFinished();
    }

    public boolean isCancelVisible() {
        return this.cancelVisible;
    }

    public boolean isLastVisible() {
        return this.lastVisible;
    }

    public final void removeListener(IWizardModelListener listener) {
        this.wizardModelListeners.remove(listener);
    }

    public void setCancelVisible(boolean cancelVisible) {
        this.cancelVisible = cancelVisible;
    }

    public void setLastVisible(boolean lastVisible) {
        this.lastVisible = lastVisible;
    }

    protected final void fireActiveStepChanged(IWizardStep step) {
        Iterator i = this.wizardModelListeners.iterator();
        while (i.hasNext()) {
            IWizardModelListener listener = (IWizardModelListener)i.next();
            listener.onActiveStepChanged(step);
        }
    }

    protected final void fireWizardCancelled() {
        Iterator i = this.wizardModelListeners.iterator();
        while (i.hasNext()) {
            IWizardModelListener listener = (IWizardModelListener)i.next();
            listener.onCancel();
        }
    }

    protected final void fireWizardFinished() {
        Iterator i = this.wizardModelListeners.iterator();
        while (i.hasNext()) {
            IWizardModelListener listener = (IWizardModelListener)i.next();
            listener.onFinish();
        }
    }
}

