/*
 * Decompiled with CFR 0.152.
 */
package org.apache.catalina.websocket;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.ByteBuffer;
import java.nio.charset.MalformedInputException;
import java.nio.charset.UnmappableCharacterException;
import org.apache.catalina.websocket.Utf8Decoder;
import org.apache.catalina.websocket.WsFrame;
import org.apache.catalina.websocket.WsInputStream;
import org.apache.catalina.websocket.WsOutbound;
import org.apache.coyote.http11.upgrade.UpgradeInbound;
import org.apache.coyote.http11.upgrade.UpgradeOutbound;
import org.apache.coyote.http11.upgrade.UpgradeProcessor;
import org.apache.tomcat.util.net.AbstractEndpoint;

public abstract class StreamInbound
implements UpgradeInbound {
    private final ClassLoader applicationClassLoader = Thread.currentThread().getContextClassLoader();
    private UpgradeProcessor<?> processor = null;
    private WsOutbound outbound;
    private int outboundByteBufferSize = 8192;
    private int outboundCharBufferSize = 8192;

    public int getOutboundByteBufferSize() {
        return this.outboundByteBufferSize;
    }

    public void setOutboundByteBufferSize(int outboundByteBufferSize) {
        this.outboundByteBufferSize = outboundByteBufferSize;
    }

    public int getOutboundCharBufferSize() {
        return this.outboundCharBufferSize;
    }

    public void setOutboundCharBufferSize(int outboundCharBufferSize) {
        this.outboundCharBufferSize = outboundCharBufferSize;
    }

    public final void setUpgradeOutbound(UpgradeOutbound upgradeOutbound) {
        this.outbound = new WsOutbound(upgradeOutbound, this.outboundByteBufferSize, this.outboundCharBufferSize);
    }

    public final void setUpgradeProcessor(UpgradeProcessor<?> processor) {
        this.processor = processor;
    }

    public final WsOutbound getWsOutbound() {
        return this.outbound;
    }

    public final AbstractEndpoint.Handler.SocketState onData() throws IOException {
        WsInputStream wsIs = new WsInputStream(this.processor, this.getWsOutbound());
        try {
            WsFrame frame = wsIs.nextFrame(true);
            while (frame != null) {
                if (frame.getRsv() > 0) {
                    this.closeOutboundConnection(1002, null);
                    return AbstractEndpoint.Handler.SocketState.CLOSED;
                }
                byte opCode = frame.getOpCode();
                if (opCode == 2) {
                    this.doOnBinaryData(wsIs);
                } else if (opCode == 1) {
                    InputStreamReader r = new InputStreamReader((InputStream)wsIs, new Utf8Decoder());
                    this.doOnTextData(r);
                } else {
                    if (opCode == 8) {
                        this.closeOutboundConnection(frame);
                        return AbstractEndpoint.Handler.SocketState.CLOSED;
                    }
                    if (opCode == 9) {
                        this.getWsOutbound().pong(frame.getPayLoad());
                    } else if (opCode != 10) {
                        this.closeOutboundConnection(1002, null);
                        return AbstractEndpoint.Handler.SocketState.CLOSED;
                    }
                }
                frame = wsIs.nextFrame(false);
            }
        }
        catch (MalformedInputException mie) {
            this.closeOutboundConnection(1007, null);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        catch (UnmappableCharacterException uce) {
            this.closeOutboundConnection(1007, null);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        catch (IOException ioe) {
            this.closeOutboundConnection(1002, null);
            return AbstractEndpoint.Handler.SocketState.CLOSED;
        }
        return AbstractEndpoint.Handler.SocketState.UPGRADED;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnBinaryData(InputStream is) throws IOException {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onBinaryData(is);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnTextData(Reader r) throws IOException {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onTextData(r);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundConnection(int status, ByteBuffer data) throws IOException {
        try {
            this.getWsOutbound().close(status, data);
        }
        finally {
            this.doOnClose(status);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeOutboundConnection(WsFrame frame) throws IOException {
        try {
            this.getWsOutbound().close(frame);
        }
        finally {
            this.doOnClose(8);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doOnClose(int status) {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onClose(status);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void onUpgradeComplete() {
        Thread t = Thread.currentThread();
        ClassLoader cl = t.getContextClassLoader();
        t.setContextClassLoader(this.applicationClassLoader);
        try {
            this.onOpen(this.outbound);
        }
        finally {
            t.setContextClassLoader(cl);
        }
    }

    protected void onOpen(WsOutbound outbound) {
    }

    protected void onClose(int status) {
    }

    protected abstract void onBinaryData(InputStream var1) throws IOException;

    protected abstract void onTextData(Reader var1) throws IOException;

    public int getReadTimeout() {
        return -1;
    }
}

