/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import java.io.IOException;
import java.io.Writer;
import org.apache.tiles.ArrayStack;
import org.apache.tiles.Attribute;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.template.AttributeResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetAsStringModel {
    private Logger log = LoggerFactory.getLogger(this.getClass());
    private AttributeResolver attributeResolver;

    public GetAsStringModel(AttributeResolver attributeResolver) {
        this.attributeResolver = attributeResolver;
    }

    public void start(ArrayStack<Object> composeStack, TilesContainer container, boolean ignore, String preparer, String role, Object defaultValue, String defaultValueRole, String defaultValueType, String name, Attribute value, Object ... requestItems) {
        Attribute attribute = this.resolveAttribute(container, ignore, preparer, role, defaultValue, defaultValueRole, defaultValueType, name, value, requestItems);
        composeStack.push((Object)attribute);
    }

    public void end(ArrayStack<Object> composeStack, TilesContainer container, Writer writer, boolean ignore, Object ... requestItems) throws IOException {
        Attribute attribute = (Attribute)composeStack.pop();
        this.renderAttribute(attribute, container, writer, ignore, requestItems);
    }

    public void execute(TilesContainer container, Writer writer, boolean ignore, String preparer, String role, Object defaultValue, String defaultValueRole, String defaultValueType, String name, Attribute value, Object ... requestItems) throws IOException {
        Attribute attribute = this.resolveAttribute(container, ignore, preparer, role, defaultValue, defaultValueRole, defaultValueType, name, value, requestItems);
        this.renderAttribute(attribute, container, writer, ignore, requestItems);
    }

    private Attribute resolveAttribute(TilesContainer container, boolean ignore, String preparer, String role, Object defaultValue, String defaultValueRole, String defaultValueType, String name, Attribute value, Object ... requestItems) {
        if (preparer != null) {
            container.prepare(preparer, requestItems);
        }
        Attribute attribute = this.attributeResolver.computeAttribute(container, value, name, role, ignore, defaultValue, defaultValueRole, defaultValueType, requestItems);
        container.startContext(requestItems);
        return attribute;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderAttribute(Attribute attribute, TilesContainer container, Writer writer, boolean ignore, Object ... requestItems) throws IOException {
        if (attribute == null && ignore) {
            return;
        }
        try {
            writer.write(attribute.getValue().toString());
        }
        catch (IOException e) {
            if (!ignore) {
                throw e;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignoring exception", (Throwable)e);
            }
        }
        catch (RuntimeException e) {
            if (!ignore) {
                throw e;
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug("Ignoring exception", (Throwable)e);
            }
        }
        finally {
            container.endContext(requestItems);
        }
    }
}

