/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.template;

import org.apache.tiles.ArrayStack;
import org.apache.tiles.Attribute;
import org.apache.tiles.Definition;
import org.apache.tiles.mgmt.MutableTilesContainer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefinitionModel {
    public void start(ArrayStack<Object> composeStack, String name, String template, String role, String extendsParam, String preparer) {
        Definition definition = this.createDefinition(name, template, role, extendsParam, preparer);
        composeStack.push((Object)definition);
    }

    public void end(MutableTilesContainer container, ArrayStack<Object> composeStack, Object ... requestItems) {
        Definition definition = (Definition)composeStack.pop();
        this.registerDefinition(definition, container, composeStack, requestItems);
    }

    public void execute(MutableTilesContainer container, ArrayStack<Object> composeStack, String name, String template, String role, String extendsParam, String preparer, Object ... requestItems) {
        Definition definition = this.createDefinition(name, template, role, extendsParam, preparer);
        this.registerDefinition(definition, container, composeStack, requestItems);
    }

    private Definition createDefinition(String name, String template, String role, String extendsParam, String preparer) {
        Definition definition = new Definition();
        definition.setName(name);
        Attribute templateAttribute = Attribute.createTemplateAttribute((String)template);
        templateAttribute.setRole(role);
        definition.setTemplateAttribute(templateAttribute);
        definition.setExtends(extendsParam);
        definition.setPreparer(preparer);
        return definition;
    }

    private void registerDefinition(Definition definition, MutableTilesContainer container, ArrayStack<Object> composeStack, Object ... requestItems) {
        container.register(definition, requestItems);
        if (composeStack.isEmpty()) {
            return;
        }
        Object obj = composeStack.peek();
        if (obj instanceof Attribute) {
            Attribute attribute = (Attribute)obj;
            attribute.setValue((Object)definition.getName());
            if (attribute.getRenderer() == null) {
                attribute.setRenderer("definition");
            }
        }
    }
}

