/*
 * $Id: SharedVariableFactory.java 1066788 2011-02-03 11:49:11Z apetrelli $
 *
 * Licensed to the Apache Software Foundation (ASF) under one
 * or more contributor license agreements.  See the NOTICE file
 * distributed with this work for additional information
 * regarding copyright ownership.  The ASF licenses this file
 * to you under the Apache License, Version 2.0 (the
 * "License"); you may not use this file except in compliance
 * with the License.  You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.apache.tiles.request.freemarker.servlet;

import freemarker.template.TemplateModel;

/**
 * It is an object that can create a shared variable, as a template model.
 *
 * @version $Rev: 1066788 $ $Date: 2011-02-03 22:49:11 +1100 (Thu, 03 Feb 2011) $
 */
public interface SharedVariableFactory {

    /**
     * Creates a new shared variable.
     *
     * @return The shared variable.
     */
    TemplateModel create();
}
