/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.util;

import java.util.Map;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.services.Coercion;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class StringToEnumCoercion<T extends Enum>
implements Coercion<String, T> {
    private final Class<T> enumClass;
    private final Map<String, T> stringToEnum = CollectionFactory.newCaseInsensitiveMap();

    public StringToEnumCoercion(Class<T> enumClass) {
        this(enumClass, (Enum[])enumClass.getEnumConstants());
    }

    public StringToEnumCoercion(Class<T> enumClass, T ... values) {
        this.enumClass = enumClass;
        for (T value : values) {
            this.stringToEnum.put(((Enum)value).name(), value);
        }
    }

    @Override
    public T coerce(String input) {
        if (InternalUtils.isBlank(input)) {
            return null;
        }
        Enum result = (Enum)this.stringToEnum.get(input);
        if (result == null) {
            String message = String.format("Input '%s' does not identify a value from enumerated type %s.", input, this.enumClass.getName());
            throw new UnknownValueException(message, new AvailableValues(this.enumClass.getName() + " enum constants", this.stringToEnum));
        }
        return (T)result;
    }

    public StringToEnumCoercion<T> addAlias(String alias, T value) {
        this.stringToEnum.put(alias, value);
        return this;
    }

    public static <T extends Enum> StringToEnumCoercion<T> create(Class<T> enumClass) {
        return new StringToEnumCoercion<T>(enumClass);
    }
}

