/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal.services;

import org.apache.tapestry5.ioc.AnnotationProvider;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.ObjectProvider;
import org.apache.tapestry5.ioc.annotations.IntermediateType;
import org.apache.tapestry5.ioc.annotations.Value;
import org.apache.tapestry5.ioc.services.Builtin;
import org.apache.tapestry5.ioc.services.SymbolSource;
import org.apache.tapestry5.ioc.services.TypeCoercer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ValueObjectProvider
implements ObjectProvider {
    private final SymbolSource symbolSource;
    private final TypeCoercer typeCoercer;

    public ValueObjectProvider(@Builtin SymbolSource symbolSource, @Builtin TypeCoercer typeCoercer) {
        this.symbolSource = symbolSource;
        this.typeCoercer = typeCoercer;
    }

    @Override
    public <T> T provide(Class<T> objectType, AnnotationProvider annotationProvider, ObjectLocator locator) {
        Value annotation = annotationProvider.getAnnotation(Value.class);
        if (annotation == null) {
            return null;
        }
        String value = annotation.value();
        String expanded = this.symbolSource.expandSymbols(value);
        IntermediateType intermediate = annotationProvider.getAnnotation(IntermediateType.class);
        if (intermediate != null) {
            expanded = this.typeCoercer.coerce(expanded, intermediate.value());
        }
        return this.typeCoercer.coerce(expanded, objectType);
    }
}

