/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.ioc.AdvisorDef;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.Markable;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ObjectLocator;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.ServiceLifecycle2;
import org.apache.tapestry5.ioc.ServiceResources;
import org.apache.tapestry5.ioc.annotations.Local;
import org.apache.tapestry5.ioc.def.ContributionDef;
import org.apache.tapestry5.ioc.def.ContributionDef2;
import org.apache.tapestry5.ioc.def.DecoratorDef;
import org.apache.tapestry5.ioc.def.ModuleDef;
import org.apache.tapestry5.ioc.def.ModuleDef2;
import org.apache.tapestry5.ioc.def.ServiceDef;
import org.apache.tapestry5.ioc.def.ServiceDef3;
import org.apache.tapestry5.ioc.internal.AdvisorStackBuilder;
import org.apache.tapestry5.ioc.internal.EagerLoadServiceProxy;
import org.apache.tapestry5.ioc.internal.IOCMessages;
import org.apache.tapestry5.ioc.internal.InterceptorStackBuilder;
import org.apache.tapestry5.ioc.internal.InternalRegistry;
import org.apache.tapestry5.ioc.internal.LifecycleWrappedServiceCreator;
import org.apache.tapestry5.ioc.internal.Module;
import org.apache.tapestry5.ioc.internal.ObjectLocatorImpl;
import org.apache.tapestry5.ioc.internal.OperationTrackingObjectCreator;
import org.apache.tapestry5.ioc.internal.RecursiveServiceCreationCheckWrapper;
import org.apache.tapestry5.ioc.internal.SerializationSupport;
import org.apache.tapestry5.ioc.internal.ServiceActivityTracker;
import org.apache.tapestry5.ioc.internal.ServiceProxyToken;
import org.apache.tapestry5.ioc.internal.ServiceResourcesImpl;
import org.apache.tapestry5.ioc.internal.services.JustInTimeObjectCreator;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.ConcurrentBarrier;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.MapInjectionResources;
import org.apache.tapestry5.ioc.services.AspectDecorator;
import org.apache.tapestry5.ioc.services.PlasticProxyFactory;
import org.apache.tapestry5.ioc.services.Status;
import org.apache.tapestry5.plastic.ClassInstantiator;
import org.apache.tapestry5.plastic.InstructionBuilder;
import org.apache.tapestry5.plastic.InstructionBuilderCallback;
import org.apache.tapestry5.plastic.MethodDescription;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticClassTransformer;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.plastic.PlasticMethod;
import org.slf4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ModuleImpl
implements Module {
    private final InternalRegistry registry;
    private final ServiceActivityTracker tracker;
    private final ModuleDef2 moduleDef;
    private final PlasticProxyFactory proxyFactory;
    private final Logger logger;
    private Object moduleInstance;
    private boolean insideConstructor;
    private final Map<String, Object> services = CollectionFactory.newCaseInsensitiveMap();
    private final Map<String, ServiceDef3> serviceDefs = CollectionFactory.newCaseInsensitiveMap();
    private static final ConcurrentBarrier BARRIER = new ConcurrentBarrier();
    private static final MethodDescription WRITE_REPLACE = new MethodDescription(2, "java.lang.Object", "writeReplace", null, null, new String[]{ObjectStreamException.class.getName()});
    private final Runnable instantiateModule = new Runnable(){

        public void run() {
            ModuleImpl.this.moduleInstance = ModuleImpl.this.registry.invoke("Constructing module class " + ModuleImpl.this.moduleDef.getBuilderClass().getName(), new Invokable(){

                public Object invoke() {
                    return ModuleImpl.this.instantiateModuleInstance();
                }
            });
        }
    };
    private final Invokable provideModuleInstance = new Invokable<Object>(){

        @Override
        public Object invoke() {
            if (ModuleImpl.this.moduleInstance == null) {
                BARRIER.withWrite(ModuleImpl.this.instantiateModule);
            }
            return ModuleImpl.this.moduleInstance;
        }
    };

    public ModuleImpl(InternalRegistry registry, ServiceActivityTracker tracker, ModuleDef moduleDef, PlasticProxyFactory proxyFactory, Logger logger) {
        this.registry = registry;
        this.tracker = tracker;
        this.proxyFactory = proxyFactory;
        this.moduleDef = InternalUtils.toModuleDef2(moduleDef);
        this.logger = logger;
        for (String id : moduleDef.getServiceIds()) {
            ServiceDef sd = moduleDef.getServiceDef(id);
            ServiceDef3 sd3 = InternalUtils.toServiceDef3(sd);
            this.serviceDefs.put(id, sd3);
        }
    }

    @Override
    public <T> T getService(String serviceId, Class<T> serviceInterface) {
        assert (InternalUtils.isNonBlank(serviceId));
        assert (serviceInterface != null);
        ServiceDef3 def = this.getServiceDef(serviceId);
        assert (def != null);
        Object service = this.findOrCreate(def, null);
        try {
            return serviceInterface.cast(service);
        }
        catch (ClassCastException ex) {
            throw new RuntimeException(IOCMessages.serviceWrongInterface(serviceId, def.getServiceInterface(), serviceInterface));
        }
    }

    @Override
    public Set<DecoratorDef> findMatchingDecoratorDefs(ServiceDef serviceDef) {
        Set<DecoratorDef> result = CollectionFactory.newSet();
        for (DecoratorDef def : this.moduleDef.getDecoratorDefs()) {
            if (!def.matches(serviceDef) && !this.markerMatched(serviceDef, InternalUtils.toDecoratorDef2(def))) continue;
            result.add(def);
        }
        return result;
    }

    @Override
    public Set<AdvisorDef> findMatchingServiceAdvisors(ServiceDef serviceDef) {
        Set<AdvisorDef> result = CollectionFactory.newSet();
        for (AdvisorDef def : this.moduleDef.getAdvisorDefs()) {
            if (!def.matches(serviceDef) && !this.markerMatched(serviceDef, InternalUtils.toAdvisorDef2(def))) continue;
            result.add(def);
        }
        return result;
    }

    @Override
    public Collection<String> findServiceIdsForInterface(Class serviceInterface) {
        assert (serviceInterface != null);
        List<String> result = CollectionFactory.newList();
        for (ServiceDef3 def : this.serviceDefs.values()) {
            if (!serviceInterface.isAssignableFrom(def.getServiceInterface())) continue;
            result.add(def.getServiceId());
        }
        return result;
    }

    private Object findOrCreate(final ServiceDef3 def, final Collection<EagerLoadServiceProxy> eagerLoadProxies) {
        final String key = def.getServiceId();
        final Invokable create = new Invokable(){

            public Object invoke() {
                Object result = ModuleImpl.this.services.get(key);
                if (result == null) {
                    result = ModuleImpl.this.create(def, eagerLoadProxies);
                    ModuleImpl.this.services.put(key, result);
                }
                return result;
            }
        };
        Invokable find = new Invokable(){

            public Object invoke() {
                Object result = ModuleImpl.this.services.get(key);
                if (result == null) {
                    result = BARRIER.withWrite(create);
                }
                return result;
            }
        };
        return BARRIER.withRead(find);
    }

    @Override
    public void collectEagerLoadServices(final Collection<EagerLoadServiceProxy> proxies) {
        Runnable work = new Runnable(){

            public void run() {
                for (ServiceDef3 def : ModuleImpl.this.serviceDefs.values()) {
                    if (!def.isEagerLoad()) continue;
                    ModuleImpl.this.findOrCreate(def, proxies);
                }
            }
        };
        this.registry.run("Eager loading services", work);
    }

    private Object create(final ServiceDef3 def, final Collection<EagerLoadServiceProxy> eagerLoadProxies) {
        final String serviceId = def.getServiceId();
        final Logger logger = this.registry.getServiceLogger(serviceId);
        String description = IOCMessages.creatingService(serviceId);
        if (logger.isDebugEnabled()) {
            logger.debug(description);
        }
        final ModuleImpl module = this;
        Invokable operation = new Invokable(){

            public Object invoke() {
                try {
                    boolean allowDecoration;
                    ServiceResourcesImpl resources = new ServiceResourcesImpl(ModuleImpl.this.registry, module, def, ModuleImpl.this.proxyFactory, logger);
                    ObjectCreator creator = def.createServiceCreator(resources);
                    Class serviceInterface = def.getServiceInterface();
                    ServiceLifecycle2 lifecycle = ModuleImpl.this.registry.getServiceLifecycle(def.getServiceScope());
                    if (!serviceInterface.isInterface()) {
                        if (lifecycle.requiresProxy()) {
                            throw new IllegalArgumentException(String.format("Service scope '%s' requires a proxy, but the service does not have a service interface (necessary to create a proxy). Provide a service interface or select a different service scope.", def.getServiceScope()));
                        }
                        return creator.createObject();
                    }
                    creator = new OperationTrackingObjectCreator(ModuleImpl.this.registry, "Invoking " + creator.toString(), creator);
                    creator = new LifecycleWrappedServiceCreator(lifecycle, resources, creator);
                    boolean bl = allowDecoration = !def.isPreventDecoration();
                    if (allowDecoration) {
                        creator = new AdvisorStackBuilder(def, creator, ModuleImpl.this.getAspectDecorator(), ModuleImpl.this.registry);
                        creator = new InterceptorStackBuilder(def, creator, ModuleImpl.this.registry);
                    }
                    creator = new RecursiveServiceCreationCheckWrapper(def, creator, logger);
                    creator = new OperationTrackingObjectCreator(ModuleImpl.this.registry, "Realizing service " + serviceId, creator);
                    JustInTimeObjectCreator delegate = new JustInTimeObjectCreator(ModuleImpl.this.tracker, creator, serviceId);
                    Object proxy = ModuleImpl.this.createProxy(resources, delegate);
                    ModuleImpl.this.registry.addRegistryShutdownListener(delegate);
                    if (def.isEagerLoad() && eagerLoadProxies != null) {
                        eagerLoadProxies.add(delegate);
                    }
                    ModuleImpl.this.tracker.setStatus(serviceId, Status.VIRTUAL);
                    return proxy;
                }
                catch (Exception ex) {
                    throw new RuntimeException(IOCMessages.errorBuildingService(serviceId, def, ex), ex);
                }
            }
        };
        return this.registry.invoke(description, operation);
    }

    private AspectDecorator getAspectDecorator() {
        return this.registry.invoke("Obtaining AspectDecorator service", new Invokable<AspectDecorator>(){

            @Override
            public AspectDecorator invoke() {
                return ModuleImpl.this.registry.getService(AspectDecorator.class);
            }
        });
    }

    @Override
    public Object getModuleBuilder() {
        return BARRIER.withRead(this.provideModuleInstance);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object instantiateModuleInstance() {
        Class moduleClass = this.moduleDef.getBuilderClass();
        Constructor<?>[] constructors = moduleClass.getConstructors();
        if (constructors.length == 0) {
            throw new RuntimeException(IOCMessages.noPublicConstructors(moduleClass));
        }
        if (constructors.length > 1) {
            Comparator<Constructor> comparator = new Comparator<Constructor>(){

                @Override
                public int compare(Constructor c1, Constructor c2) {
                    return c2.getParameterTypes().length - c1.getParameterTypes().length;
                }
            };
            Arrays.sort(constructors, comparator);
            this.logger.warn(IOCMessages.tooManyPublicConstructors(moduleClass, constructors[0]));
        }
        Constructor<?> constructor = constructors[0];
        if (this.insideConstructor) {
            throw new RuntimeException(IOCMessages.recursiveModuleConstructor(moduleClass, constructor));
        }
        ObjectLocatorImpl locator = new ObjectLocatorImpl(this.registry, this);
        Map<Class, Object> resourcesMap = CollectionFactory.newMap();
        resourcesMap.put(Logger.class, this.logger);
        resourcesMap.put(ObjectLocator.class, locator);
        resourcesMap.put(OperationTracker.class, this.registry);
        MapInjectionResources resources = new MapInjectionResources(resourcesMap);
        Throwable fail = null;
        try {
            this.insideConstructor = true;
            Object[] parameterValues = InternalUtils.calculateParameters(locator, resources, constructor.getParameterTypes(), constructor.getGenericParameterTypes(), constructor.getParameterAnnotations(), this.registry);
            Object result = constructor.newInstance(parameterValues);
            InternalUtils.injectIntoFields(result, locator, resources, this.registry);
            Object obj = result;
            return obj;
        }
        catch (InvocationTargetException ex) {
            fail = ex.getTargetException();
        }
        catch (Exception ex) {
            fail = ex;
        }
        finally {
            this.insideConstructor = false;
        }
        throw new RuntimeException(IOCMessages.instantiateBuilderError(moduleClass, fail), fail);
    }

    private Object createProxy(ServiceResources resources, ObjectCreator creator) {
        String serviceId = resources.getServiceId();
        Class serviceInterface = resources.getServiceInterface();
        String toString = String.format("<Proxy for %s(%s)>", serviceId, serviceInterface.getName());
        ServiceProxyToken token = SerializationSupport.createToken(serviceId);
        return this.createProxyInstance(creator, token, serviceInterface, resources.getImplementationClass(), toString);
    }

    private Object createProxyInstance(final ObjectCreator creator, final ServiceProxyToken token, final Class serviceInterface, Class serviceImplementation, final String description) {
        ClassInstantiator instantiator = this.proxyFactory.createProxy(serviceInterface, new PlasticClassTransformer(){

            public void transform(final PlasticClass plasticClass) {
                plasticClass.introduceInterface(Serializable.class);
                final PlasticField creatorField = plasticClass.introduceField(ObjectCreator.class, "creator").inject((Object)creator);
                final PlasticField tokenField = plasticClass.introduceField(ServiceProxyToken.class, "token").inject((Object)token);
                PlasticMethod delegateMethod = plasticClass.introducePrivateMethod(serviceInterface.getName(), "delegate", null, null);
                delegateMethod.changeImplementation(new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadThis().getField(plasticClass.getClassName(), creatorField.getName(), ObjectCreator.class);
                        builder.invoke(ObjectCreator.class, Object.class, "createObject", new Class[0]).checkcast(serviceInterface).returnResult();
                    }
                });
                for (Method m : serviceInterface.getMethods()) {
                    plasticClass.introduceMethod(m).delegateTo(delegateMethod);
                }
                plasticClass.introduceMethod(WRITE_REPLACE).changeImplementation(new InstructionBuilderCallback(){

                    public void doBuild(InstructionBuilder builder) {
                        builder.loadThis().getField(plasticClass.getClassName(), tokenField.getName(), ServiceProxyToken.class).returnResult();
                    }
                });
                plasticClass.addToString(description);
            }
        });
        return instantiator.newInstance();
    }

    @Override
    public Set<ContributionDef2> getContributorDefsForService(ServiceDef serviceDef) {
        Set<ContributionDef2> result = CollectionFactory.newSet();
        for (ContributionDef next : this.moduleDef.getContributionDefs()) {
            ContributionDef2 def = InternalUtils.toContributionDef2(next);
            if (serviceDef.getServiceId().equalsIgnoreCase(def.getServiceId())) {
                result.add(def);
                continue;
            }
            if (!this.markerMatched(serviceDef, def)) continue;
            result.add(def);
        }
        return result;
    }

    private boolean markerMatched(ServiceDef serviceDef, Markable markable) {
        Class markableInterface = markable.getServiceInterface();
        if (markableInterface == null || !markableInterface.isAssignableFrom(serviceDef.getServiceInterface())) {
            return false;
        }
        Set contributionMarkers = CollectionFactory.newSet(markable.getMarkers());
        if (contributionMarkers.contains(Local.class)) {
            if (!this.isLocalServiceDef(serviceDef)) {
                return false;
            }
            contributionMarkers.remove(Local.class);
        }
        contributionMarkers.retainAll(this.registry.getMarkerAnnotations());
        if (markableInterface == Object.class && contributionMarkers.isEmpty()) {
            return false;
        }
        return serviceDef.getMarkers().containsAll(contributionMarkers);
    }

    private boolean isLocalServiceDef(ServiceDef serviceDef) {
        return this.serviceDefs.containsKey(serviceDef.getServiceId());
    }

    @Override
    public ServiceDef3 getServiceDef(String serviceId) {
        return this.serviceDefs.get(serviceId);
    }

    @Override
    public String getLoggerName() {
        return this.moduleDef.getLoggerName();
    }

    public String toString() {
        return String.format("ModuleImpl[%s]", this.moduleDef.getLoggerName());
    }
}

