/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.ioc.internal;

import java.util.List;
import org.apache.tapestry5.ioc.ObjectCreator;
import org.apache.tapestry5.ioc.ServiceAdvisor;
import org.apache.tapestry5.ioc.def.ServiceDef3;
import org.apache.tapestry5.ioc.internal.InternalRegistry;
import org.apache.tapestry5.ioc.services.AspectDecorator;
import org.apache.tapestry5.ioc.services.AspectInterceptorBuilder;

public class AdvisorStackBuilder
implements ObjectCreator {
    private final ServiceDef3 serviceDef;
    private final ObjectCreator delegate;
    private final AspectDecorator aspectDecorator;
    private final InternalRegistry registry;

    public AdvisorStackBuilder(ServiceDef3 serviceDef, ObjectCreator delegate, AspectDecorator aspectDecorator, InternalRegistry registry) {
        this.serviceDef = serviceDef;
        this.delegate = delegate;
        this.registry = registry;
        this.aspectDecorator = aspectDecorator;
    }

    public Object createObject() {
        Object service = this.delegate.createObject();
        List<ServiceAdvisor> advisors = this.registry.findAdvisorsForService(this.serviceDef);
        if (advisors.isEmpty()) {
            return service;
        }
        final AspectInterceptorBuilder builder = this.aspectDecorator.createBuilder(this.serviceDef.getServiceInterface(), service, this.serviceDef, String.format("<AspectProxy for %s(%s)>", this.serviceDef.getServiceId(), this.serviceDef.getServiceInterface().getName()));
        for (final ServiceAdvisor advisor : advisors) {
            this.registry.run("Invoking " + advisor, new Runnable(){

                public void run() {
                    advisor.advise(builder);
                }
            });
        }
        return builder.build();
    }
}

