/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kinesis.spout;

import com.amazonaws.regions.Region;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.kinesis.AmazonKinesisClient;
import com.amazonaws.services.kinesis.model.DescribeStreamRequest;
import com.amazonaws.services.kinesis.model.DescribeStreamResult;
import com.amazonaws.services.kinesis.model.GetRecordsRequest;
import com.amazonaws.services.kinesis.model.GetRecordsResult;
import com.amazonaws.services.kinesis.model.GetShardIteratorRequest;
import com.amazonaws.services.kinesis.model.GetShardIteratorResult;
import com.amazonaws.services.kinesis.model.Shard;
import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.storm.kinesis.spout.KinesisConnectionInfo;
import org.apache.storm.kinesis.spout.KinesisRecordsManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class KinesisConnection {
    private static final Logger LOG = LoggerFactory.getLogger(KinesisRecordsManager.class);
    private final KinesisConnectionInfo kinesisConnectionInfo;
    private AmazonKinesisClient kinesisClient;

    KinesisConnection(KinesisConnectionInfo kinesisConnectionInfo) {
        this.kinesisConnectionInfo = kinesisConnectionInfo;
    }

    void initialize() {
        this.kinesisClient = new AmazonKinesisClient(this.kinesisConnectionInfo.getCredentialsProvider(), this.kinesisConnectionInfo.getClientConfiguration());
        this.kinesisClient.setRegion(Region.getRegion((Regions)this.kinesisConnectionInfo.getRegion()));
    }

    List<Shard> getShardsForStream(String stream) {
        DescribeStreamResult describeStreamResult;
        DescribeStreamRequest describeStreamRequest = new DescribeStreamRequest();
        describeStreamRequest.setStreamName(stream);
        ArrayList<Shard> shards = new ArrayList<Shard>();
        String exclusiveStartShardId = null;
        do {
            describeStreamRequest.setExclusiveStartShardId(exclusiveStartShardId);
            describeStreamResult = this.kinesisClient.describeStream(describeStreamRequest);
            shards.addAll(describeStreamResult.getStreamDescription().getShards());
        } while ((exclusiveStartShardId = describeStreamResult.getStreamDescription().getHasMoreShards() != false && shards.size() > 0 ? ((Shard)shards.get(shards.size() - 1)).getShardId() : null) != null);
        LOG.info("Number of shards for stream " + stream + " are " + shards.size());
        return shards;
    }

    String getShardIterator(String stream, String shardId, ShardIteratorType shardIteratorType, String sequenceNumber, Date timestamp) {
        String shardIterator = "";
        try {
            GetShardIteratorRequest getShardIteratorRequest = new GetShardIteratorRequest();
            getShardIteratorRequest.setStreamName(stream);
            getShardIteratorRequest.setShardId(shardId);
            getShardIteratorRequest.setShardIteratorType(shardIteratorType);
            if (shardIteratorType.equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || shardIteratorType.equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER)) {
                getShardIteratorRequest.setStartingSequenceNumber(sequenceNumber);
            } else if (shardIteratorType.equals((Object)ShardIteratorType.AT_TIMESTAMP)) {
                getShardIteratorRequest.setTimestamp(timestamp);
            }
            GetShardIteratorResult getShardIteratorResult = this.kinesisClient.getShardIterator(getShardIteratorRequest);
            if (getShardIteratorResult != null) {
                shardIterator = getShardIteratorResult.getShardIterator();
            }
        }
        catch (Exception e) {
            LOG.warn("Exception occured while getting shardIterator for shard " + shardId + " shardIteratorType " + shardIteratorType + " sequence number " + sequenceNumber + " timestamp " + timestamp, (Throwable)e);
        }
        LOG.warn("Returning shardIterator " + shardIterator + " for shardId " + shardId + " shardIteratorType " + shardIteratorType + " sequenceNumber " + sequenceNumber + " timestamp" + timestamp);
        return shardIterator;
    }

    GetRecordsResult fetchRecords(String shardIterator) {
        GetRecordsRequest getRecordsRequest = new GetRecordsRequest();
        getRecordsRequest.setShardIterator(shardIterator);
        getRecordsRequest.setLimit(this.kinesisConnectionInfo.getRecordsLimit());
        GetRecordsResult getRecordsResult = this.kinesisClient.getRecords(getRecordsRequest);
        return getRecordsResult;
    }

    void shutdown() {
        this.kinesisClient.shutdown();
    }
}

