/*
 * Decompiled with CFR 0.152.
 */
package org.apache.storm.kinesis.spout;

import com.amazonaws.services.kinesis.model.ShardIteratorType;
import java.io.Serializable;
import java.util.Date;
import org.apache.storm.kinesis.spout.FailedMessageRetryHandler;
import org.apache.storm.kinesis.spout.KinesisConnectionInfo;
import org.apache.storm.kinesis.spout.RecordToTupleMapper;
import org.apache.storm.kinesis.spout.ZkInfo;

public class KinesisConfig
implements Serializable {
    private final String streamName;
    private final ShardIteratorType shardIteratorType;
    private final RecordToTupleMapper recordToTupleMapper;
    private final Date timestamp;
    private final FailedMessageRetryHandler failedMessageRetryHandler;
    private final ZkInfo zkInfo;
    private final KinesisConnectionInfo kinesisConnectionInfo;
    private final Long maxUncommittedRecords;

    public KinesisConfig(String streamName, ShardIteratorType shardIteratorType, RecordToTupleMapper recordToTupleMapper, Date timestamp, FailedMessageRetryHandler failedMessageRetryHandler, ZkInfo zkInfo, KinesisConnectionInfo kinesisConnectionInfo, Long maxUncommittedRecords) {
        this.streamName = streamName;
        this.shardIteratorType = shardIteratorType;
        this.recordToTupleMapper = recordToTupleMapper;
        this.timestamp = timestamp;
        this.failedMessageRetryHandler = failedMessageRetryHandler;
        this.zkInfo = zkInfo;
        this.kinesisConnectionInfo = kinesisConnectionInfo;
        this.maxUncommittedRecords = maxUncommittedRecords;
        this.validate();
    }

    private void validate() {
        if (this.streamName == null || this.streamName.length() < 1) {
            throw new IllegalArgumentException("streamName is required and cannot be of length 0.");
        }
        if (this.shardIteratorType == null || this.shardIteratorType.equals((Object)ShardIteratorType.AFTER_SEQUENCE_NUMBER) || this.shardIteratorType.equals((Object)ShardIteratorType.AT_SEQUENCE_NUMBER)) {
            throw new IllegalArgumentException("shardIteratorType has to be one of the " + ShardIteratorType.AT_TIMESTAMP + "," + ShardIteratorType.LATEST + "," + ShardIteratorType.TRIM_HORIZON);
        }
        if (this.shardIteratorType.equals((Object)ShardIteratorType.AT_TIMESTAMP) && this.timestamp == null) {
            throw new IllegalArgumentException("timestamp must be provided if shardIteratorType is " + ShardIteratorType.AT_TIMESTAMP);
        }
        if (this.recordToTupleMapper == null) {
            throw new IllegalArgumentException("recordToTupleMapper cannot be null");
        }
        if (this.failedMessageRetryHandler == null) {
            throw new IllegalArgumentException("failedMessageRetryHandler cannot be null");
        }
        if (this.zkInfo == null) {
            throw new IllegalArgumentException("zkInfo cannot be null");
        }
        if (this.kinesisConnectionInfo == null) {
            throw new IllegalArgumentException("kinesisConnectionInfo cannot be null");
        }
        if (this.maxUncommittedRecords == null || this.maxUncommittedRecords < 1L) {
            throw new IllegalArgumentException("maxUncommittedRecords has to be a positive integer");
        }
    }

    public String getStreamName() {
        return this.streamName;
    }

    public ShardIteratorType getShardIteratorType() {
        return this.shardIteratorType;
    }

    public RecordToTupleMapper getRecordToTupleMapper() {
        return this.recordToTupleMapper;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public FailedMessageRetryHandler getFailedMessageRetryHandler() {
        return this.failedMessageRetryHandler;
    }

    public ZkInfo getZkInfo() {
        return this.zkInfo;
    }

    public KinesisConnectionInfo getKinesisConnectionInfo() {
        return this.kinesisConnectionInfo;
    }

    public Long getMaxUncommittedRecords() {
        return this.maxUncommittedRecords;
    }

    public String toString() {
        return "KinesisConfig{streamName='" + this.streamName + '\'' + ", shardIteratorType=" + this.shardIteratorType + ", recordToTupleMapper=" + this.recordToTupleMapper + ", timestamp=" + this.timestamp + ", zkInfo=" + this.zkInfo + ", kinesisConnectionInfo=" + this.kinesisConnectionInfo + ", failedMessageRetryHandler =" + this.failedMessageRetryHandler + ", maxUncommittedRecords=" + this.maxUncommittedRecords + '}';
    }
}

