/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.operator.logical;

import java.util.Collections;
import java.util.Objects;
import lombok.Generated;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.rex.RexNode;
import org.apache.shardingsphere.sqlfederation.optimizer.operator.util.LogicalScanPushDownRelBuilder;

public final class LogicalScan
extends TableScan {
    private final LogicalScanPushDownRelBuilder pushDownRelBuilder;
    private final String databaseType;

    public LogicalScan(TableScan tableScan, String databaseType) {
        super(tableScan.getCluster(), tableScan.getTraitSet(), Collections.emptyList(), tableScan.getTable());
        this.databaseType = databaseType;
        this.pushDownRelBuilder = LogicalScanPushDownRelBuilder.create(tableScan);
        this.pushDownRelBuilder.scan(tableScan.getTable().getQualifiedName());
        this.resetRowType((RelNode)tableScan);
    }

    private void resetRowType(RelNode relNode) {
        this.rowType = relNode.getRowType();
    }

    public void pushDown(LogicalFilter logicalFilter) {
        this.pushDownRelBuilder.filter(logicalFilter.getVariablesSet(), new RexNode[]{logicalFilter.getCondition()});
        this.resetRowType((RelNode)logicalFilter);
    }

    public void pushDown(LogicalProject logicalProject) {
        this.pushDownRelBuilder.project(logicalProject.getProjects(), logicalProject.getRowType().getFieldNames());
        this.resetRowType((RelNode)logicalProject);
    }

    public RelNode peek() {
        return this.pushDownRelBuilder.peek();
    }

    public boolean deepEquals(Object other) {
        if (this.pushDownRelBuilder.peek() instanceof LogicalTableScan) {
            return super.deepEquals(other);
        }
        if (this == other) {
            return true;
        }
        if (null == other || ((Object)((Object)this)).getClass() != other.getClass()) {
            return false;
        }
        LogicalScan otherLogicalScan = (LogicalScan)((Object)other);
        return this.traitSet.equals((Object)otherLogicalScan.getTraitSet()) && this.pushDownRelBuilder.peek().deepEquals((Object)otherLogicalScan.pushDownRelBuilder.peek()) && this.hints.equals((Object)otherLogicalScan.hints) && this.getRowType().equalsSansFieldNames(otherLogicalScan.getRowType());
    }

    public int deepHashCode() {
        if (this.pushDownRelBuilder.peek() instanceof LogicalTableScan) {
            return super.deepHashCode();
        }
        return Objects.hash(this.traitSet, this.pushDownRelBuilder.peek().deepHashCode(), this.hints);
    }

    public RelWriter explainTerms(RelWriter relWriter) {
        return super.explainTerms(relWriter).item("pushDownRelBuilder", (Object)this.pushDownRelBuilder);
    }

    @Generated
    public LogicalScanPushDownRelBuilder getPushDownRelBuilder() {
        return this.pushDownRelBuilder;
    }

    @Generated
    public String getDatabaseType() {
        return this.databaseType;
    }
}

