/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.orderby.item;

import java.util.Collections;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNumericLiteral;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlPostfixOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.infra.database.core.metadata.database.enums.NullsOrderType;
import org.apache.shardingsphere.sql.parser.sql.common.enums.OrderDirection;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.order.item.IndexOrderByItemSegment;

public final class IndexOrderByItemConverter {
    public static Optional<SqlNode> convert(IndexOrderByItemSegment segment) {
        SqlNumericLiteral result = SqlLiteral.createExactNumeric((String)String.valueOf(segment.getColumnIndex()), (SqlParserPos)SqlParserPos.ZERO);
        if (OrderDirection.DESC == segment.getOrderDirection()) {
            result = new SqlBasicCall((SqlOperator)SqlStdOperatorTable.DESC, Collections.singletonList(result), SqlParserPos.ZERO);
        }
        if (segment.getNullsOrderType().isPresent()) {
            SqlPostfixOperator nullsOrderType = NullsOrderType.FIRST == segment.getNullsOrderType().get() ? SqlStdOperatorTable.NULLS_FIRST : SqlStdOperatorTable.NULLS_LAST;
            result = new SqlBasicCall((SqlOperator)nullsOrderType, Collections.singletonList(result), SqlParserPos.ZERO);
        }
        return Optional.of(result);
    }

    @Generated
    private IndexOrderByItemConverter() {
    }
}

