/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.sqlfederation.optimizer.converter.segment.from.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SimpleTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.TableNameSegment;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SimpleTableConverter {
    public static Optional<SqlNode> convert(SimpleTableSegment segment) {
        if ("DUAL".equalsIgnoreCase(segment.getTableName().getIdentifier().getValue())) {
            return Optional.empty();
        }
        TableNameSegment tableName = segment.getTableName();
        ArrayList<String> names = new ArrayList<String>();
        if (segment.getOwner().isPresent()) {
            SimpleTableConverter.addOwnerNames(names, (OwnerSegment)segment.getOwner().get());
        }
        names.add(tableName.getIdentifier().getValue());
        if (segment.getDbLink().isPresent() && segment.getAt().isPresent()) {
            names.add(((IdentifierValue)segment.getAt().get()).getValue());
            names.add(((IdentifierValue)segment.getDbLink().get()).getValue());
        }
        SqlIdentifier tableNameSQLNode = new SqlIdentifier(names, SqlParserPos.ZERO);
        if (segment.getAliasName().isPresent()) {
            SqlIdentifier aliasSQLNode = new SqlIdentifier((String)segment.getAliasName().get(), SqlParserPos.ZERO);
            return Optional.of(new SqlBasicCall((SqlOperator)SqlStdOperatorTable.AS, Arrays.asList(tableNameSQLNode, aliasSQLNode), SqlParserPos.ZERO));
        }
        return Optional.of(tableNameSQLNode);
    }

    private static void addOwnerNames(List<String> names, OwnerSegment owner) {
        if (null != owner) {
            SimpleTableConverter.addOwnerNames(names, owner.getOwner().orElse(null));
            names.add(owner.getIdentifier().getValue());
        }
    }

    @Generated
    private SimpleTableConverter() {
    }
}

