/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.infra.binder.segment.from.impl;

import com.google.common.base.Strings;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.binder.context.segment.select.projection.util.ProjectionUtils;
import org.apache.shardingsphere.infra.binder.segment.from.SimpleTableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.from.TableSegmentBinderContext;
import org.apache.shardingsphere.infra.binder.segment.parameter.impl.ParameterMarkerExpressionSegmentBinder;
import org.apache.shardingsphere.infra.binder.statement.SQLStatementBinderContext;
import org.apache.shardingsphere.infra.binder.statement.dml.SelectStatementBinder;
import org.apache.shardingsphere.infra.database.core.type.DatabaseType;
import org.apache.shardingsphere.infra.database.core.type.DatabaseTypeRegistry;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.column.ColumnSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.ExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.simple.ParameterMarkerExpressionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.expr.subquery.SubquerySegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.AggregationProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ColumnProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ExpressionProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.dml.item.ShorthandProjectionSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasAvailable;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.AliasSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.OwnerSegment;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.bounded.ColumnSegmentBoundedInfo;
import org.apache.shardingsphere.sql.parser.sql.common.segment.generic.table.SubqueryTableSegment;
import org.apache.shardingsphere.sql.parser.sql.common.statement.dml.SelectStatement;
import org.apache.shardingsphere.sql.parser.sql.common.value.identifier.IdentifierValue;

public final class SubqueryTableSegmentBinder {
    public static SubqueryTableSegment bind(SubqueryTableSegment segment, SQLStatementBinderContext statementBinderContext, Map<String, TableSegmentBinderContext> tableBinderContexts, Map<String, TableSegmentBinderContext> outerTableBinderContexts) {
        SubqueryTableSegmentBinder.fillPivotColumnNamesInBinderContext(segment, statementBinderContext);
        SelectStatement boundedSelect = new SelectStatementBinder().bindCorrelateSubquery(segment.getSubquery().getSelect(), statementBinderContext.getMetaData(), statementBinderContext.getDefaultDatabaseName(), outerTableBinderContexts, statementBinderContext.getExternalTableBinderContexts());
        SubquerySegment boundedSubquerySegment = new SubquerySegment(segment.getSubquery().getStartIndex(), segment.getSubquery().getStopIndex(), boundedSelect, segment.getSubquery().getText());
        boundedSubquerySegment.setSubqueryType(segment.getSubquery().getSubqueryType());
        IdentifierValue subqueryTableName = segment.getAliasSegment().map(AliasSegment::getIdentifier).orElseGet(() -> new IdentifierValue(""));
        SubqueryTableSegmentBinder.bindParameterMarkerProjection(boundedSubquerySegment, subqueryTableName);
        SubqueryTableSegment result = new SubqueryTableSegment(boundedSubquerySegment);
        segment.getAliasSegment().ifPresent(arg_0 -> ((SubqueryTableSegment)result).setAlias(arg_0));
        tableBinderContexts.put(subqueryTableName.getValue().toLowerCase(), new SimpleTableSegmentBinderContext(SubqueryTableSegmentBinder.createSubqueryProjections(boundedSelect.getProjections().getProjections(), subqueryTableName, statementBinderContext.getDatabaseType())));
        return result;
    }

    private static void bindParameterMarkerProjection(SubquerySegment boundedSubquerySegment, IdentifierValue subqueryTableName) {
        SelectStatement boundedSelect = boundedSubquerySegment.getSelect();
        LinkedList projections = new LinkedList(boundedSelect.getProjections().getProjections());
        boundedSelect.getProjections().getProjections().clear();
        for (ProjectionSegment each : projections) {
            if (!(each instanceof ParameterMarkerExpressionSegment)) {
                boundedSelect.getProjections().getProjections().add(each);
                continue;
            }
            ParameterMarkerExpressionSegment parameterMarkerProjection = (ParameterMarkerExpressionSegment)each;
            boundedSelect.getProjections().getProjections().add(ParameterMarkerExpressionSegmentBinder.bind(parameterMarkerProjection, Collections.singletonMap(parameterMarkerProjection, new ColumnSegmentBoundedInfo(new IdentifierValue(""), new IdentifierValue(""), subqueryTableName, parameterMarkerProjection.getAlias().orElseGet(() -> new IdentifierValue(""))))));
        }
    }

    private static void fillPivotColumnNamesInBinderContext(SubqueryTableSegment segment, SQLStatementBinderContext statementBinderContext) {
        segment.getPivot().ifPresent(optional -> optional.getPivotColumns().forEach(each -> statementBinderContext.getPivotColumnNames().add(each.getIdentifier().getValue().toLowerCase())));
    }

    private static Collection<ProjectionSegment> createSubqueryProjections(Collection<ProjectionSegment> projections, IdentifierValue subqueryTableName, DatabaseType databaseType) {
        LinkedList<ProjectionSegment> result = new LinkedList<ProjectionSegment>();
        for (ProjectionSegment each : projections) {
            if (each instanceof ColumnProjectionSegment) {
                result.add((ProjectionSegment)SubqueryTableSegmentBinder.createColumnProjection((ColumnProjectionSegment)each, subqueryTableName));
                continue;
            }
            if (each instanceof ShorthandProjectionSegment) {
                result.addAll(SubqueryTableSegmentBinder.createSubqueryProjections(((ShorthandProjectionSegment)each).getActualProjectionSegments(), subqueryTableName, databaseType));
                continue;
            }
            if (each instanceof ExpressionProjectionSegment) {
                result.add((ProjectionSegment)SubqueryTableSegmentBinder.createColumnProjection((ExpressionSegment)((ExpressionProjectionSegment)each), subqueryTableName, databaseType));
                continue;
            }
            if (each instanceof AggregationProjectionSegment) {
                result.add((ProjectionSegment)SubqueryTableSegmentBinder.createColumnProjection((ExpressionSegment)((AggregationProjectionSegment)each), subqueryTableName, databaseType));
                continue;
            }
            result.add(each);
        }
        return result;
    }

    private static ColumnProjectionSegment createColumnProjection(ColumnProjectionSegment originalColumn, IdentifierValue subqueryTableName) {
        ColumnSegment newColumnSegment = new ColumnSegment(0, 0, originalColumn.getAlias().orElseGet(() -> originalColumn.getColumn().getIdentifier()));
        if (!Strings.isNullOrEmpty((String)subqueryTableName.getValue())) {
            newColumnSegment.setOwner(new OwnerSegment(0, 0, subqueryTableName));
        }
        newColumnSegment.setColumnBoundedInfo(new ColumnSegmentBoundedInfo(originalColumn.getColumn().getColumnBoundedInfo().getOriginalDatabase(), originalColumn.getColumn().getColumnBoundedInfo().getOriginalSchema(), originalColumn.getColumn().getColumnBoundedInfo().getOriginalTable(), originalColumn.getColumn().getColumnBoundedInfo().getOriginalColumn()));
        ColumnProjectionSegment result = new ColumnProjectionSegment(newColumnSegment);
        result.setVisible(originalColumn.isVisible());
        return result;
    }

    private static ColumnProjectionSegment createColumnProjection(ExpressionSegment expressionSegment, IdentifierValue subqueryTableName, DatabaseType databaseType) {
        ColumnSegment newColumnSegment = new ColumnSegment(0, 0, new IdentifierValue(SubqueryTableSegmentBinder.getColumnNameFromExpression(expressionSegment, databaseType), new DatabaseTypeRegistry(databaseType).getDialectDatabaseMetaData().getQuoteCharacter()));
        if (!Strings.isNullOrEmpty((String)subqueryTableName.getValue())) {
            newColumnSegment.setOwner(new OwnerSegment(0, 0, subqueryTableName));
        }
        ColumnProjectionSegment result = new ColumnProjectionSegment(newColumnSegment);
        result.setVisible(true);
        return result;
    }

    private static String getColumnNameFromExpression(ExpressionSegment expressionSegment, DatabaseType databaseType) {
        String result = expressionSegment instanceof AliasAvailable && ((AliasAvailable)expressionSegment).getAlias().isPresent() ? ProjectionUtils.getColumnLabelFromAlias((IdentifierValue)((AliasAvailable)expressionSegment).getAlias().get(), databaseType) : ProjectionUtils.getColumnNameFromExpression(expressionSegment.getText(), databaseType);
        return result;
    }

    @Generated
    private SubqueryTableSegmentBinder() {
    }
}

