/*
 * Decompiled with CFR 0.152.
 */
package org.apache.rocketmq.srvutil;

import com.google.common.base.Strings;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import org.apache.rocketmq.common.ServiceThread;
import org.apache.rocketmq.common.UtilAll;
import org.apache.rocketmq.logging.InternalLogger;
import org.apache.rocketmq.logging.InternalLoggerFactory;

public class FileWatchService
extends ServiceThread {
    private static final InternalLogger log = InternalLoggerFactory.getLogger((String)"RocketmqCommon");
    private final List<String> watchFiles;
    private final List<String> fileCurrentHash;
    private final Listener listener;
    private static final int WATCH_INTERVAL = 500;
    private MessageDigest md = MessageDigest.getInstance("MD5");

    public FileWatchService(String[] watchFiles, Listener listener) throws Exception {
        this.listener = listener;
        this.watchFiles = new ArrayList<String>();
        this.fileCurrentHash = new ArrayList<String>();
        for (int i = 0; i < watchFiles.length; ++i) {
            if (Strings.isNullOrEmpty((String)watchFiles[i]) || !new File(watchFiles[i]).exists()) continue;
            this.watchFiles.add(watchFiles[i]);
            this.fileCurrentHash.add(this.hash(watchFiles[i]));
        }
    }

    public String getServiceName() {
        return "FileWatchService";
    }

    public void run() {
        log.info(this.getServiceName() + " service started");
        while (!this.isStopped()) {
            try {
                this.waitForRunning(500L);
                for (int i = 0; i < this.watchFiles.size(); ++i) {
                    String newHash;
                    try {
                        newHash = this.hash(this.watchFiles.get(i));
                    }
                    catch (Exception ignored) {
                        log.warn(this.getServiceName() + " service has exception when calculate the file hash. ", (Throwable)ignored);
                        continue;
                    }
                    if (newHash.equals(this.fileCurrentHash.get(i))) continue;
                    this.fileCurrentHash.set(i, newHash);
                    this.listener.onChanged(this.watchFiles.get(i));
                }
            }
            catch (Exception e) {
                log.warn(this.getServiceName() + " service has exception. ", (Throwable)e);
            }
        }
        log.info(this.getServiceName() + " service end");
    }

    private String hash(String filePath) throws IOException, NoSuchAlgorithmException {
        Path path = Paths.get(filePath, new String[0]);
        this.md.update(Files.readAllBytes(path));
        byte[] hash = this.md.digest();
        return UtilAll.bytes2string((byte[])hash);
    }

    public static interface Listener {
        public void onChanged(String var1);
    }
}

