/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.proton.reactor.impl;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.Pipe;
import java.util.HashSet;
import java.util.Set;
import org.apache.qpid.proton.Proton;
import org.apache.qpid.proton.engine.BaseHandler;
import org.apache.qpid.proton.engine.Collector;
import org.apache.qpid.proton.engine.Connection;
import org.apache.qpid.proton.engine.Event;
import org.apache.qpid.proton.engine.EventType;
import org.apache.qpid.proton.engine.Extendable;
import org.apache.qpid.proton.engine.ExtendableAccessor;
import org.apache.qpid.proton.engine.Handler;
import org.apache.qpid.proton.engine.HandlerException;
import org.apache.qpid.proton.engine.Record;
import org.apache.qpid.proton.engine.impl.CollectorImpl;
import org.apache.qpid.proton.engine.impl.ConnectionImpl;
import org.apache.qpid.proton.engine.impl.RecordImpl;
import org.apache.qpid.proton.reactor.Acceptor;
import org.apache.qpid.proton.reactor.Reactor;
import org.apache.qpid.proton.reactor.ReactorChild;
import org.apache.qpid.proton.reactor.Selectable;
import org.apache.qpid.proton.reactor.Selector;
import org.apache.qpid.proton.reactor.Task;
import org.apache.qpid.proton.reactor.impl.AcceptorImpl;
import org.apache.qpid.proton.reactor.impl.Address;
import org.apache.qpid.proton.reactor.impl.IO;
import org.apache.qpid.proton.reactor.impl.IOHandler;
import org.apache.qpid.proton.reactor.impl.IOImpl;
import org.apache.qpid.proton.reactor.impl.ReactorInternalException;
import org.apache.qpid.proton.reactor.impl.SelectableImpl;
import org.apache.qpid.proton.reactor.impl.TaskImpl;
import org.apache.qpid.proton.reactor.impl.Timer;

public class ReactorImpl
implements Reactor,
Extendable {
    public static final ExtendableAccessor<Event, Handler> ROOT = new ExtendableAccessor(Handler.class);
    private CollectorImpl collector = (CollectorImpl)Proton.collector();
    private long now;
    private long timeout;
    private Handler global = new IOHandler();
    private Handler handler = new BaseHandler();
    private Set<ReactorChild> children = new HashSet<ReactorChild>();
    private int selectables = 0;
    private boolean yield;
    private boolean stop;
    private Selectable selectable;
    private EventType previous;
    private Timer timer = new Timer(this.collector);
    private final Pipe wakeup;
    private Selector selector;
    private Record attachments;
    private final IO io;
    protected static final String CONNECTION_PEER_ADDRESS_KEY = "pn_reactor_connection_peer_address";

    @Override
    public long mark() {
        this.now = System.currentTimeMillis();
        return this.now;
    }

    @Override
    public long now() {
        return this.now;
    }

    protected ReactorImpl(IO io) throws IOException {
        this.io = io;
        this.wakeup = this.io.pipe();
        this.mark();
        this.attachments = new RecordImpl();
    }

    public ReactorImpl() throws IOException {
        this(new IOImpl());
    }

    @Override
    public void free() {
        if (this.wakeup.source().isOpen()) {
            try {
                this.wakeup.source().close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.wakeup.sink().isOpen()) {
            try {
                this.wakeup.sink().close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        if (this.selector != null) {
            this.selector.free();
        }
        for (ReactorChild child : this.children) {
            child.free();
        }
    }

    @Override
    public Record attachments() {
        return this.attachments;
    }

    @Override
    public long getTimeout() {
        return this.timeout;
    }

    @Override
    public void setTimeout(long timeout) {
        this.timeout = timeout;
    }

    @Override
    public Handler getGlobalHandler() {
        return this.global;
    }

    @Override
    public void setGlobalHandler(Handler handler) {
        this.global = handler;
    }

    @Override
    public Handler getHandler() {
        return this.handler;
    }

    @Override
    public void setHandler(Handler handler) {
        this.handler = handler;
    }

    @Override
    public Set<ReactorChild> children() {
        return this.children;
    }

    @Override
    public Collector collector() {
        return this.collector;
    }

    @Override
    public Selectable selectable() {
        return this.selectable(null);
    }

    public SelectableImpl selectable(ReactorChild child) {
        SelectableImpl result = new SelectableImpl();
        result.setCollector(this.collector);
        this.collector.put(Event.Type.SELECTABLE_INIT, result);
        result.setReactor(this);
        this.children.add(child == null ? result : child);
        result.onRelease(new ReleaseCallback(this, child == null ? result : child));
        ++this.selectables;
        return result;
    }

    @Override
    public void update(Selectable selectable) {
        SelectableImpl selectableImpl = (SelectableImpl)selectable;
        if (!selectableImpl.isTerminated()) {
            if (selectableImpl.isTerminal()) {
                selectableImpl.terminated();
                this.collector.put(Event.Type.SELECTABLE_FINAL, selectable);
            } else {
                this.collector.put(Event.Type.SELECTABLE_UPDATED, selectable);
            }
        }
    }

    private Handler eventHandler(Event event) {
        Handler result;
        if (event.getLink() != null && (result = BaseHandler.getHandler(event.getLink())) != null) {
            return result;
        }
        if (event.getSession() != null && (result = BaseHandler.getHandler(event.getSession())) != null) {
            return result;
        }
        if (event.getConnection() != null && (result = BaseHandler.getHandler(event.getConnection())) != null) {
            return result;
        }
        if (event.getTask() != null && (result = BaseHandler.getHandler(event.getTask())) != null) {
            return result;
        }
        if (event.getSelectable() != null && (result = BaseHandler.getHandler(event.getSelectable())) != null) {
            return result;
        }
        return this.handler;
    }

    @Override
    public void yield() {
        this.yield = true;
    }

    @Override
    public boolean quiesced() {
        Event event = this.collector.peek();
        if (event == null) {
            return true;
        }
        if (this.collector.more()) {
            return false;
        }
        return event.getEventType() == Event.Type.REACTOR_QUIESCED;
    }

    @Override
    public boolean process() throws HandlerException {
        this.mark();
        EventType previous = null;
        while (true) {
            Event event;
            if ((event = this.collector.peek()) != null) {
                if (this.yield) {
                    this.yield = false;
                    return true;
                }
                Handler handler = this.eventHandler(event);
                this.dispatch(event, handler);
                this.dispatch(event, this.global);
                if (event.getEventType() == Event.Type.CONNECTION_FINAL) {
                    this.children.remove(event.getConnection());
                }
                previous = this.previous = event.getEventType();
                this.collector.pop();
                continue;
            }
            if (!this.stop && this.more()) {
                if (previous != Event.Type.REACTOR_QUIESCED && this.previous != Event.Type.REACTOR_FINAL) {
                    this.collector.put(Event.Type.REACTOR_QUIESCED, this);
                    continue;
                }
                return true;
            }
            if (this.selectable == null) break;
            this.selectable.terminate();
            this.update(this.selectable);
            this.selectable = null;
        }
        this.collector.put(Event.Type.REACTOR_FINAL, this);
        return false;
    }

    private void dispatch(Event event, Handler handler) {
        ROOT.set(event, handler);
        event.dispatch(handler);
    }

    @Override
    public void wakeup() {
        try {
            this.wakeup.sink().write(ByteBuffer.allocate(1));
        }
        catch (ClosedChannelException channelClosedException) {
        }
        catch (IOException ioException) {
            throw new ReactorInternalException(ioException);
        }
    }

    @Override
    public void start() {
        this.collector.put(Event.Type.REACTOR_INIT, this);
        this.selectable = this.timerSelectable();
    }

    @Override
    public void stop() throws HandlerException {
        this.stop = true;
    }

    private boolean more() {
        return this.timer.tasks() > 0 || this.selectables > 1;
    }

    @Override
    public void run() throws HandlerException {
        this.setTimeout(3141L);
        this.start();
        while (this.process()) {
        }
        this.stop();
        this.process();
        this.collector = null;
    }

    @Override
    public Task schedule(int delay, Handler handler) {
        Task task = this.timer.schedule(this.now + (long)delay);
        ((TaskImpl)task).setReactor(this);
        BaseHandler.setHandler(task, handler);
        if (this.selectable != null) {
            this.selectable.setDeadline(this.timer.deadline());
            this.update(this.selectable);
        }
        return task;
    }

    private void expireSelectable(Selectable selectable) {
        ReactorImpl reactor = (ReactorImpl)selectable.getReactor();
        reactor.timer.tick(reactor.now);
        selectable.setDeadline(reactor.timer.deadline());
        reactor.update(selectable);
    }

    private Selectable timerSelectable() {
        Selectable sel = this.selectable();
        sel.setChannel(this.wakeup.source());
        sel.onReadable(new TimerReadable());
        sel.onExpired(new TimerExpired());
        sel.onFree(new TimerFree());
        sel.setReading(true);
        sel.setDeadline(this.timer.deadline());
        this.update(sel);
        return sel;
    }

    protected Selector getSelector() {
        return this.selector;
    }

    protected void setSelector(Selector selector) {
        this.selector = selector;
    }

    @Override
    public Connection connection(Handler handler) {
        Connection connection = Proton.connection();
        BaseHandler.setHandler(connection, handler);
        connection.collect(this.collector);
        this.children.add(connection);
        ((ConnectionImpl)connection).setReactor(this);
        return connection;
    }

    @Override
    public Connection connectionToHost(String host, int port, Handler handler) {
        Connection connection = this.connection(handler);
        this.setConnectionHost(connection, host, port);
        return connection;
    }

    @Override
    public String getConnectionAddress(Connection connection) {
        Record r = connection.attachments();
        Address addr = r.get(CONNECTION_PEER_ADDRESS_KEY, Address.class);
        if (addr != null) {
            StringBuilder sb = new StringBuilder(addr.getHost());
            if (addr.getPort() != null) {
                sb.append(":" + addr.getPort());
            }
            return sb.toString();
        }
        return null;
    }

    @Override
    public void setConnectionHost(Connection connection, String host, int port) {
        Address addr;
        Record r = connection.attachments();
        if (r.get("pn_reactor_connection_acceptor", Acceptor.class) == null) {
            addr = new Address();
            addr.setHost(host);
            if (port == 0) {
                port = 5672;
            }
        } else {
            throw new IllegalStateException("Cannot set the host address on an incoming Connection");
        }
        addr.setPort(Integer.toString(port));
        r.set(CONNECTION_PEER_ADDRESS_KEY, Address.class, addr);
    }

    @Override
    public Acceptor acceptor(String host, int port) throws IOException {
        return this.acceptor(host, port, null);
    }

    @Override
    public Acceptor acceptor(String host, int port, Handler handler) throws IOException {
        return new AcceptorImpl(this, host, port, handler);
    }

    public IO getIO() {
        return this.io;
    }

    private static class TimerFree
    implements Selectable.Callback {
        private TimerFree() {
        }

        @Override
        public void run(Selectable selectable) {
            try {
                selectable.getChannel().close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private class TimerExpired
    implements Selectable.Callback {
        private TimerExpired() {
        }

        @Override
        public void run(Selectable selectable) {
            ReactorImpl.this.expireSelectable(selectable);
        }
    }

    private class TimerReadable
    implements Selectable.Callback {
        private TimerReadable() {
        }

        @Override
        public void run(Selectable selectable) {
            try {
                ReactorImpl.this.wakeup.source().read(ByteBuffer.allocate(64));
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            ReactorImpl.this.expireSelectable(selectable);
        }
    }

    private class ReleaseCallback
    implements Selectable.Callback {
        private final ReactorImpl reactor;
        private final ReactorChild child;

        public ReleaseCallback(ReactorImpl reactor, ReactorChild child) {
            this.reactor = reactor;
            this.child = child;
        }

        @Override
        public void run(Selectable selectable) {
            if (this.reactor.children.remove(this.child)) {
                --this.reactor.selectables;
                this.child.free();
            }
        }
    }
}

