/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.POIXMLException;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawTextShape;
import org.apache.poi.sl.usermodel.Insets2D;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.sl.usermodel.TextShape;
import org.apache.poi.sl.usermodel.VerticalAlignment;
import org.apache.poi.util.Units;
import org.apache.poi.xslf.model.TextBodyPropertyFetcher;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFSheet;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextRun;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBody;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextBodyProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextCharacterProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextListStyle;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraph;
import org.openxmlformats.schemas.drawingml.x2006.main.CTTextParagraphProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextAnchoringType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextVerticalType;
import org.openxmlformats.schemas.drawingml.x2006.main.STTextWrappingType;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;

public abstract class XSLFTextShape
extends XSLFSimpleShape
implements TextShape<XSLFShape, XSLFTextParagraph> {
    private final List<XSLFTextParagraph> _paragraphs = new ArrayList<XSLFTextParagraph>();

    XSLFTextShape(XmlObject shape, XSLFSheet sheet) {
        super(shape, sheet);
        CTTextBody txBody = this.getTextBody(false);
        if (txBody != null) {
            for (CTTextParagraph p : txBody.getPArray()) {
                this._paragraphs.add(new XSLFTextParagraph(p, this));
            }
        }
    }

    public Iterator<XSLFTextParagraph> iterator() {
        return this.getTextParagraphs().iterator();
    }

    public String getText() {
        StringBuilder out = new StringBuilder();
        for (XSLFTextParagraph p : this._paragraphs) {
            if (out.length() > 0) {
                out.append('\n');
            }
            out.append(p.getText());
        }
        return out.toString();
    }

    public void clearText() {
        this._paragraphs.clear();
        CTTextBody txBody = this.getTextBody(true);
        txBody.setPArray(null);
    }

    public XSLFTextRun setText(String text) {
        CTTextParagraphProperties pPr = null;
        CTTextCharacterProperties rPr = null;
        if (!this._paragraphs.isEmpty()) {
            XSLFTextParagraph p0 = this._paragraphs.get(0);
            pPr = p0.getXmlObject().getPPr();
            if (!p0.getTextRuns().isEmpty()) {
                XSLFTextRun r0 = p0.getTextRuns().get(0);
                rPr = r0.getXmlObject().getRPr();
            }
        }
        this._paragraphs.clear();
        CTTextBody txBody = this.getTextBody(true);
        int cntPs = txBody.sizeOfPArray();
        XSLFTextRun r = null;
        for (String paraText : text.split("\\r\\n?|\\n")) {
            XSLFTextParagraph para = this.addNewTextParagraph();
            if (pPr != null) {
                para.getXmlObject().setPPr(pPr);
            }
            boolean first = true;
            for (String runText : paraText.split("[\u000b]")) {
                if (!first) {
                    para.addLineBreak();
                }
                r = para.addNewTextRun();
                r.setText(runText);
                if (rPr != null) {
                    r.getXmlObject().setRPr(rPr);
                }
                first = false;
            }
        }
        for (int i = cntPs - 1; i >= 0; --i) {
            txBody.removeP(i);
        }
        return r;
    }

    public List<XSLFTextParagraph> getTextParagraphs() {
        return this._paragraphs;
    }

    public XSLFTextParagraph addNewTextParagraph() {
        CTTextBody txBody = this.getTextBody(true);
        CTTextParagraph p = txBody.addNewP();
        XSLFTextParagraph paragraph = new XSLFTextParagraph(p, this);
        this._paragraphs.add(paragraph);
        return paragraph;
    }

    public void setVerticalAlignment(VerticalAlignment anchor) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            if (anchor == null) {
                if (bodyPr.isSetAnchor()) {
                    bodyPr.unsetAnchor();
                }
            } else {
                bodyPr.setAnchor(STTextAnchoringType.Enum.forInt((int)(anchor.ordinal() + 1)));
            }
        }
    }

    public VerticalAlignment getVerticalAlignment() {
        TextBodyPropertyFetcher<VerticalAlignment> fetcher = new TextBodyPropertyFetcher<VerticalAlignment>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetAnchor()) {
                    int val = props.getAnchor().intValue();
                    this.setValue(VerticalAlignment.values()[val - 1]);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? VerticalAlignment.TOP : (VerticalAlignment)fetcher.getValue();
    }

    public void setHorizontalCentered(Boolean isCentered) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            if (isCentered == null) {
                if (bodyPr.isSetAnchorCtr()) {
                    bodyPr.unsetAnchorCtr();
                }
            } else {
                bodyPr.setAnchorCtr(isCentered.booleanValue());
            }
        }
    }

    public boolean isHorizontalCentered() {
        TextBodyPropertyFetcher<Boolean> fetcher = new TextBodyPropertyFetcher<Boolean>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetAnchorCtr()) {
                    this.setValue(props.getAnchorCtr());
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? false : (Boolean)fetcher.getValue();
    }

    public void setTextDirection(TextShape.TextDirection orientation) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            if (orientation == null) {
                if (bodyPr.isSetVert()) {
                    bodyPr.unsetVert();
                }
            } else {
                bodyPr.setVert(STTextVerticalType.Enum.forInt((int)(orientation.ordinal() + 1)));
            }
        }
    }

    public TextShape.TextDirection getTextDirection() {
        STTextVerticalType.Enum val;
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null && (val = bodyPr.getVert()) != null) {
            return TextShape.TextDirection.values()[val.intValue() - 1];
        }
        return TextShape.TextDirection.HORIZONTAL;
    }

    public Double getTextRotation() {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null && bodyPr.isSetRot()) {
            return (double)bodyPr.getRot() / 60000.0;
        }
        return null;
    }

    public void setTextRotation(Double rotation) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            bodyPr.setRot((int)(rotation * 60000.0));
        }
    }

    public double getBottomInset() {
        TextBodyPropertyFetcher<Double> fetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetBIns()) {
                    double val = Units.toPoints((long)props.getBIns());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? 3.6 : (Double)fetcher.getValue();
    }

    public double getLeftInset() {
        TextBodyPropertyFetcher<Double> fetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetLIns()) {
                    double val = Units.toPoints((long)props.getLIns());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? 7.2 : (Double)fetcher.getValue();
    }

    public double getRightInset() {
        TextBodyPropertyFetcher<Double> fetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetRIns()) {
                    double val = Units.toPoints((long)props.getRIns());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? 7.2 : (Double)fetcher.getValue();
    }

    public double getTopInset() {
        TextBodyPropertyFetcher<Double> fetcher = new TextBodyPropertyFetcher<Double>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetTIns()) {
                    double val = Units.toPoints((long)props.getTIns());
                    this.setValue(val);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? 3.6 : (Double)fetcher.getValue();
    }

    public void setBottomInset(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetBIns();
            } else {
                bodyPr.setBIns(Units.toEMU((double)margin));
            }
        }
    }

    public void setLeftInset(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetLIns();
            } else {
                bodyPr.setLIns(Units.toEMU((double)margin));
            }
        }
    }

    public void setRightInset(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetRIns();
            } else {
                bodyPr.setRIns(Units.toEMU((double)margin));
            }
        }
    }

    public void setTopInset(double margin) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            if (margin == -1.0) {
                bodyPr.unsetTIns();
            } else {
                bodyPr.setTIns(Units.toEMU((double)margin));
            }
        }
    }

    public Insets2D getInsets() {
        Insets2D insets = new Insets2D(this.getTopInset(), this.getLeftInset(), this.getBottomInset(), this.getRightInset());
        return insets;
    }

    public void setInsets(Insets2D insets) {
        this.setTopInset(insets.top);
        this.setLeftInset(insets.left);
        this.setBottomInset(insets.bottom);
        this.setRightInset(insets.right);
    }

    public boolean getWordWrap() {
        TextBodyPropertyFetcher<Boolean> fetcher = new TextBodyPropertyFetcher<Boolean>(){

            @Override
            public boolean fetch(CTTextBodyProperties props) {
                if (props.isSetWrap()) {
                    this.setValue(props.getWrap() == STTextWrappingType.SQUARE);
                    return true;
                }
                return false;
            }
        };
        this.fetchShapeProperty(fetcher);
        return fetcher.getValue() == null ? true : (Boolean)fetcher.getValue();
    }

    public void setWordWrap(boolean wrap) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            bodyPr.setWrap(wrap ? STTextWrappingType.SQUARE : STTextWrappingType.NONE);
        }
    }

    public void setTextAutofit(TextShape.TextAutofit value) {
        CTTextBodyProperties bodyPr = this.getTextBodyPr(true);
        if (bodyPr != null) {
            if (bodyPr.isSetSpAutoFit()) {
                bodyPr.unsetSpAutoFit();
            }
            if (bodyPr.isSetNoAutofit()) {
                bodyPr.unsetNoAutofit();
            }
            if (bodyPr.isSetNormAutofit()) {
                bodyPr.unsetNormAutofit();
            }
            switch (value) {
                case NONE: {
                    bodyPr.addNewNoAutofit();
                    break;
                }
                case NORMAL: {
                    bodyPr.addNewNormAutofit();
                    break;
                }
                case SHAPE: {
                    bodyPr.addNewSpAutoFit();
                }
            }
        }
    }

    public TextShape.TextAutofit getTextAutofit() {
        CTTextBodyProperties bodyPr = this.getTextBodyPr();
        if (bodyPr != null) {
            if (bodyPr.isSetNoAutofit()) {
                return TextShape.TextAutofit.NONE;
            }
            if (bodyPr.isSetNormAutofit()) {
                return TextShape.TextAutofit.NORMAL;
            }
            if (bodyPr.isSetSpAutoFit()) {
                return TextShape.TextAutofit.SHAPE;
            }
        }
        return TextShape.TextAutofit.NORMAL;
    }

    protected CTTextBodyProperties getTextBodyPr() {
        return this.getTextBodyPr(false);
    }

    protected CTTextBodyProperties getTextBodyPr(boolean create) {
        CTTextBody textBody = this.getTextBody(create);
        if (textBody == null) {
            return null;
        }
        CTTextBodyProperties textBodyPr = textBody.getBodyPr();
        if (textBodyPr == null && create) {
            textBodyPr = textBody.addNewBodyPr();
        }
        return textBodyPr;
    }

    protected abstract CTTextBody getTextBody(boolean var1);

    @Override
    public void setPlaceholder(SimpleShape.Placeholder placeholder) {
        super.setPlaceholder(placeholder);
    }

    public SimpleShape.Placeholder getTextType() {
        CTPlaceholder ph = this.getCTPlaceholder();
        if (ph == null) {
            return null;
        }
        int val = ph.getType().intValue();
        return SimpleShape.Placeholder.values()[val - 1];
    }

    public double getTextHeight() {
        DrawFactory drawFact = DrawFactory.getInstance(null);
        DrawTextShape dts = drawFact.getDrawable((TextShape)this);
        return dts.getTextHeight();
    }

    public Rectangle2D resizeToFitText() {
        Rectangle2D anchor = this.getAnchor();
        if (anchor.getWidth() == 0.0) {
            throw new POIXMLException("Anchor of the shape was not set.");
        }
        double height = this.getTextHeight();
        anchor.setRect(anchor.getX(), anchor.getY(), anchor.getWidth(), height += 1.0);
        this.setAnchor(anchor);
        return anchor;
    }

    @Override
    void copy(XSLFShape other) {
        VerticalAlignment vAlign;
        double bottomInset;
        double topInset;
        double rightInset;
        double leftInset;
        boolean srcWordWrap;
        super.copy(other);
        XSLFTextShape otherTS = (XSLFTextShape)other;
        CTTextBody otherTB = otherTS.getTextBody(false);
        CTTextBody thisTB = this.getTextBody(true);
        if (otherTB == null) {
            return;
        }
        thisTB.setBodyPr((CTTextBodyProperties)otherTB.getBodyPr().copy());
        if (thisTB.isSetLstStyle()) {
            thisTB.unsetLstStyle();
        }
        if (otherTB.isSetLstStyle()) {
            thisTB.setLstStyle((CTTextListStyle)otherTB.getLstStyle().copy());
        }
        if ((srcWordWrap = otherTS.getWordWrap()) != this.getWordWrap()) {
            this.setWordWrap(srcWordWrap);
        }
        if ((leftInset = otherTS.getLeftInset()) != this.getLeftInset()) {
            this.setLeftInset(leftInset);
        }
        if ((rightInset = otherTS.getRightInset()) != this.getRightInset()) {
            this.setRightInset(rightInset);
        }
        if ((topInset = otherTS.getTopInset()) != this.getTopInset()) {
            this.setTopInset(topInset);
        }
        if ((bottomInset = otherTS.getBottomInset()) != this.getBottomInset()) {
            this.setBottomInset(bottomInset);
        }
        if ((vAlign = otherTS.getVerticalAlignment()) != this.getVerticalAlignment()) {
            this.setVerticalAlignment(vAlign);
        }
        this.clearText();
        for (XSLFTextParagraph srcP : otherTS.getTextParagraphs()) {
            XSLFTextParagraph tgtP = this.addNewTextParagraph();
            tgtP.copy(srcP);
        }
    }

    public void setTextPlaceholder(TextShape.TextPlaceholder placeholder) {
        switch (placeholder) {
            default: {
                this.setPlaceholder(SimpleShape.Placeholder.BODY);
                break;
            }
            case TITLE: {
                this.setPlaceholder(SimpleShape.Placeholder.TITLE);
                break;
            }
            case CENTER_BODY: {
                this.setPlaceholder(SimpleShape.Placeholder.BODY);
                this.setHorizontalCentered(true);
                break;
            }
            case CENTER_TITLE: {
                this.setPlaceholder(SimpleShape.Placeholder.CENTERED_TITLE);
                break;
            }
            case OTHER: {
                this.setPlaceholder(SimpleShape.Placeholder.CONTENT);
            }
        }
    }

    public TextShape.TextPlaceholder getTextPlaceholder() {
        SimpleShape.Placeholder ph = this.getTextType();
        if (ph == null) {
            return TextShape.TextPlaceholder.BODY;
        }
        switch (ph) {
            case BODY: {
                return TextShape.TextPlaceholder.BODY;
            }
            case TITLE: {
                return TextShape.TextPlaceholder.TITLE;
            }
            case CENTERED_TITLE: {
                return TextShape.TextPlaceholder.CENTER_TITLE;
            }
        }
        return TextShape.TextPlaceholder.OTHER;
    }
}

