/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.xslf.usermodel;

import java.awt.Graphics2D;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.apache.poi.POIXMLDocumentPart;
import org.apache.poi.POIXMLException;
import org.apache.poi.POIXMLTypeLoader;
import org.apache.poi.openxml4j.exceptions.InvalidFormatException;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.openxml4j.opc.PackagePartName;
import org.apache.poi.openxml4j.opc.PackageRelationship;
import org.apache.poi.openxml4j.opc.TargetMode;
import org.apache.poi.sl.draw.DrawFactory;
import org.apache.poi.sl.draw.DrawPictureShape;
import org.apache.poi.sl.draw.DrawSheet;
import org.apache.poi.sl.usermodel.PictureData;
import org.apache.poi.sl.usermodel.PictureShape;
import org.apache.poi.sl.usermodel.Sheet;
import org.apache.poi.sl.usermodel.SimpleShape;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.xslf.usermodel.XMLSlideShow;
import org.apache.poi.xslf.usermodel.XSLFAutoShape;
import org.apache.poi.xslf.usermodel.XSLFBackground;
import org.apache.poi.xslf.usermodel.XSLFCommonSlideData;
import org.apache.poi.xslf.usermodel.XSLFConnectorShape;
import org.apache.poi.xslf.usermodel.XSLFDrawing;
import org.apache.poi.xslf.usermodel.XSLFFreeformShape;
import org.apache.poi.xslf.usermodel.XSLFGraphicFrame;
import org.apache.poi.xslf.usermodel.XSLFGroupShape;
import org.apache.poi.xslf.usermodel.XSLFPictureData;
import org.apache.poi.xslf.usermodel.XSLFPictureShape;
import org.apache.poi.xslf.usermodel.XSLFRelation;
import org.apache.poi.xslf.usermodel.XSLFShape;
import org.apache.poi.xslf.usermodel.XSLFShapeContainer;
import org.apache.poi.xslf.usermodel.XSLFSimpleShape;
import org.apache.poi.xslf.usermodel.XSLFTable;
import org.apache.poi.xslf.usermodel.XSLFTableRow;
import org.apache.poi.xslf.usermodel.XSLFTextBox;
import org.apache.poi.xslf.usermodel.XSLFTextParagraph;
import org.apache.poi.xslf.usermodel.XSLFTextShape;
import org.apache.poi.xslf.usermodel.XSLFTheme;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTConnector;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGraphicalObjectFrame;
import org.openxmlformats.schemas.presentationml.x2006.main.CTGroupShape;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPicture;
import org.openxmlformats.schemas.presentationml.x2006.main.CTPlaceholder;
import org.openxmlformats.schemas.presentationml.x2006.main.CTShape;

public abstract class XSLFSheet
extends POIXMLDocumentPart
implements XSLFShapeContainer,
Sheet<XSLFShape, XSLFTextParagraph> {
    private XSLFCommonSlideData _commonSlideData;
    private XSLFDrawing _drawing;
    private List<XSLFShape> _shapes;
    private CTGroupShape _spTree;
    private List<XSLFTextShape> _placeholders;
    private Map<Integer, XSLFSimpleShape> _placeholderByIdMap;
    private Map<Integer, XSLFSimpleShape> _placeholderByTypeMap;

    public XSLFSheet() {
    }

    public XSLFSheet(PackagePart part, PackageRelationship rel) {
        super(part, rel);
    }

    public XMLSlideShow getSlideShow() {
        for (POIXMLDocumentPart p = this.getParent(); p != null; p = p.getParent()) {
            if (!(p instanceof XMLSlideShow)) continue;
            return (XMLSlideShow)p;
        }
        throw new IllegalStateException("SlideShow was not found");
    }

    protected static List<XSLFShape> buildShapes(CTGroupShape spTree, XSLFSheet sheet) {
        ArrayList<XSLFShape> shapes = new ArrayList<XSLFShape>();
        for (XmlObject ch : spTree.selectPath("*")) {
            XSLFShape shape;
            if (ch instanceof CTShape) {
                shape = XSLFAutoShape.create((CTShape)ch, sheet);
                shapes.add(shape);
                continue;
            }
            if (ch instanceof CTGroupShape) {
                shapes.add(new XSLFGroupShape((CTGroupShape)ch, sheet));
                continue;
            }
            if (ch instanceof CTConnector) {
                shapes.add(new XSLFConnectorShape((CTConnector)ch, sheet));
                continue;
            }
            if (ch instanceof CTPicture) {
                shapes.add(new XSLFPictureShape((CTPicture)ch, sheet));
                continue;
            }
            if (!(ch instanceof CTGraphicalObjectFrame)) continue;
            shape = XSLFGraphicFrame.create((CTGraphicalObjectFrame)ch, sheet);
            shapes.add(shape);
        }
        return shapes;
    }

    public abstract XmlObject getXmlObject();

    @Internal
    public XSLFCommonSlideData getCommonSlideData() {
        return this._commonSlideData;
    }

    protected void setCommonSlideData(CTCommonSlideData data) {
        this._commonSlideData = data == null ? null : new XSLFCommonSlideData(data);
    }

    private XSLFDrawing getDrawing() {
        this.initDrawingAndShapes();
        return this._drawing;
    }

    public List<XSLFShape> getShapes() {
        this.initDrawingAndShapes();
        return this._shapes;
    }

    private void initDrawingAndShapes() {
        CTGroupShape cgs = this.getSpTree();
        if (this._drawing == null) {
            this._drawing = new XSLFDrawing(this, cgs);
        }
        if (this._shapes == null) {
            this._shapes = XSLFSheet.buildShapes(cgs, this);
        }
    }

    @Override
    public XSLFAutoShape createAutoShape() {
        XSLFAutoShape sh = this.getDrawing().createAutoShape();
        this.getShapes().add(sh);
        sh.setParent(this);
        return sh;
    }

    @Override
    public XSLFFreeformShape createFreeform() {
        XSLFFreeformShape sh = this.getDrawing().createFreeform();
        this.getShapes().add(sh);
        sh.setParent(this);
        return sh;
    }

    @Override
    public XSLFTextBox createTextBox() {
        XSLFTextBox sh = this.getDrawing().createTextBox();
        this.getShapes().add(sh);
        sh.setParent(this);
        return sh;
    }

    @Override
    public XSLFConnectorShape createConnector() {
        XSLFConnectorShape sh = this.getDrawing().createConnector();
        this.getShapes().add(sh);
        sh.setParent(this);
        return sh;
    }

    @Override
    public XSLFGroupShape createGroup() {
        XSLFGroupShape sh = this.getDrawing().createGroup();
        this.getShapes().add(sh);
        sh.setParent(this);
        return sh;
    }

    @Override
    public XSLFPictureShape createPicture(PictureData pictureData) {
        if (!(pictureData instanceof XSLFPictureData)) {
            throw new IllegalArgumentException("pictureData needs to be of type XSLFPictureData");
        }
        XSLFPictureData xPictureData = (XSLFPictureData)pictureData;
        PackagePart pic = xPictureData.getPackagePart();
        PackageRelationship rel = this.getPackagePart().addRelationship(pic.getPartName(), TargetMode.INTERNAL, XSLFRelation.IMAGES.getRelation());
        this.addRelation(rel.getId(), new XSLFPictureData(pic, rel));
        XSLFPictureShape sh = this.getDrawing().createPicture(rel.getId());
        new DrawPictureShape((PictureShape)sh).resize();
        this.getShapes().add(sh);
        sh.setParent(this);
        return sh;
    }

    public XSLFTable createTable() {
        XSLFTable sh = this.getDrawing().createTable();
        this.getShapes().add(sh);
        sh.setParent(this);
        return sh;
    }

    public XSLFTable createTable(int numRows, int numCols) {
        if (numRows < 1 || numCols < 1) {
            throw new IllegalArgumentException("numRows and numCols must be greater than 0");
        }
        XSLFTable sh = this.getDrawing().createTable();
        this.getShapes().add(sh);
        sh.setParent(this);
        for (int r = 0; r < numRows; ++r) {
            XSLFTableRow row = sh.addRow();
            for (int c = 0; c < numCols; ++c) {
                row.addCell();
            }
        }
        return sh;
    }

    public Iterator<XSLFShape> iterator() {
        return this.getShapes().iterator();
    }

    public void addShape(XSLFShape shape) {
        throw new UnsupportedOperationException("Adding a shape from a different container is not supported - create it from scratch witht XSLFSheet.create* methods");
    }

    public boolean removeShape(XSLFShape xShape) {
        XmlObject obj = xShape.getXmlObject();
        CTGroupShape spTree = this.getSpTree();
        if (obj instanceof CTShape) {
            spTree.getSpList().remove(obj);
        } else if (obj instanceof CTGroupShape) {
            spTree.getGrpSpList().remove(obj);
        } else if (obj instanceof CTConnector) {
            spTree.getCxnSpList().remove(obj);
        } else if (obj instanceof CTGraphicalObjectFrame) {
            spTree.getGraphicFrameList().remove(obj);
        } else if (obj instanceof CTPicture) {
            XSLFPictureShape ps = (XSLFPictureShape)xShape;
            this.removePictureRelation(ps);
            spTree.getPicList().remove(obj);
        } else {
            throw new IllegalArgumentException("Unsupported shape: " + xShape);
        }
        return this.getShapes().remove(xShape);
    }

    @Override
    public void clear() {
        ArrayList<XSLFShape> shapes = new ArrayList<XSLFShape>(this.getShapes());
        for (XSLFShape shape : shapes) {
            this.removeShape(shape);
        }
    }

    protected abstract String getRootElementName();

    protected CTGroupShape getSpTree() {
        if (this._spTree == null) {
            XmlObject root = this.getXmlObject();
            XmlObject[] sp = root.selectPath("declare namespace p='http://schemas.openxmlformats.org/presentationml/2006/main' .//*/p:spTree");
            if (sp.length == 0) {
                throw new IllegalStateException("CTGroupShape was not found");
            }
            this._spTree = (CTGroupShape)sp[0];
        }
        return this._spTree;
    }

    @Override
    protected final void commit() throws IOException {
        XmlOptions xmlOptions = new XmlOptions(POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        String docName = this.getRootElementName();
        if (docName != null) {
            xmlOptions.setSaveSyntheticDocumentElement(new QName("http://schemas.openxmlformats.org/presentationml/2006/main", docName));
        }
        PackagePart part = this.getPackagePart();
        OutputStream out = part.getOutputStream();
        this.getXmlObject().save(out, xmlOptions);
        out.close();
    }

    public XSLFSheet importContent(XSLFSheet src) {
        this._shapes = null;
        this._spTree = null;
        this._drawing = null;
        this._spTree = null;
        this._placeholders = null;
        this.getSpTree().set((XmlObject)src.getSpTree());
        List<XSLFShape> tgtShapes = this.getShapes();
        List<XSLFShape> srcShapes = src.getShapes();
        for (int i = 0; i < tgtShapes.size(); ++i) {
            XSLFShape s1 = srcShapes.get(i);
            XSLFShape s2 = tgtShapes.get(i);
            s2.copy(s1);
        }
        return this;
    }

    public XSLFSheet appendContent(XSLFSheet src) {
        CTGroupShape spTree = this.getSpTree();
        int numShapes = this.getShapes().size();
        CTGroupShape srcTree = src.getSpTree();
        for (XmlObject ch : srcTree.selectPath("*")) {
            if (ch instanceof CTShape) {
                spTree.addNewSp().set(ch);
                continue;
            }
            if (ch instanceof CTGroupShape) {
                spTree.addNewGrpSp().set(ch);
                continue;
            }
            if (ch instanceof CTConnector) {
                spTree.addNewCxnSp().set(ch);
                continue;
            }
            if (ch instanceof CTPicture) {
                spTree.addNewPic().set(ch);
                continue;
            }
            if (!(ch instanceof CTGraphicalObjectFrame)) continue;
            spTree.addNewGraphicFrame().set(ch);
        }
        this._shapes = null;
        this._spTree = null;
        this._drawing = null;
        this._spTree = null;
        this._placeholders = null;
        List<XSLFShape> tgtShapes = this.getShapes();
        List<XSLFShape> srcShapes = src.getShapes();
        for (int i = 0; i < srcShapes.size(); ++i) {
            XSLFShape s1 = srcShapes.get(i);
            XSLFShape s2 = tgtShapes.get(numShapes + i);
            s2.copy(s1);
        }
        return this;
    }

    XSLFTheme getTheme() {
        return null;
    }

    protected XSLFTextShape getTextShapeByType(SimpleShape.Placeholder type) {
        for (XSLFShape shape : this.getShapes()) {
            XSLFTextShape txt;
            if (!(shape instanceof XSLFTextShape) || (txt = (XSLFTextShape)shape).getTextType() != type) continue;
            return txt;
        }
        return null;
    }

    XSLFSimpleShape getPlaceholder(CTPlaceholder ph) {
        XSLFSimpleShape shape = null;
        if (ph.isSetIdx()) {
            shape = this.getPlaceholderById((int)ph.getIdx());
        }
        if (shape == null && ph.isSetType()) {
            shape = this.getPlaceholderByType(ph.getType().intValue());
        }
        return shape;
    }

    void initPlaceholders() {
        if (this._placeholders == null) {
            this._placeholders = new ArrayList<XSLFTextShape>();
            this._placeholderByIdMap = new HashMap<Integer, XSLFSimpleShape>();
            this._placeholderByTypeMap = new HashMap<Integer, XSLFSimpleShape>();
            for (XSLFShape sh : this.getShapes()) {
                XSLFTextShape sShape;
                CTPlaceholder ph;
                if (!(sh instanceof XSLFTextShape) || (ph = (sShape = (XSLFTextShape)sh).getCTPlaceholder()) == null) continue;
                this._placeholders.add(sShape);
                if (ph.isSetIdx()) {
                    int idx = (int)ph.getIdx();
                    this._placeholderByIdMap.put(idx, sShape);
                }
                if (!ph.isSetType()) continue;
                this._placeholderByTypeMap.put(ph.getType().intValue(), sShape);
            }
        }
    }

    XSLFSimpleShape getPlaceholderById(int id) {
        this.initPlaceholders();
        return this._placeholderByIdMap.get(id);
    }

    XSLFSimpleShape getPlaceholderByType(int ordinal) {
        this.initPlaceholders();
        return this._placeholderByTypeMap.get(ordinal);
    }

    public XSLFTextShape getPlaceholder(int idx) {
        this.initPlaceholders();
        return this._placeholders.get(idx);
    }

    public XSLFTextShape[] getPlaceholders() {
        this.initPlaceholders();
        return this._placeholders.toArray(new XSLFTextShape[this._placeholders.size()]);
    }

    protected boolean canDraw(XSLFShape shape) {
        return true;
    }

    public boolean getFollowMasterGraphics() {
        return false;
    }

    public XSLFBackground getBackground() {
        return null;
    }

    public void draw(Graphics2D graphics) {
        DrawFactory drawFact = DrawFactory.getInstance((Graphics2D)graphics);
        DrawSheet draw = drawFact.getDrawable((Sheet)this);
        draw.draw(graphics);
    }

    String importBlip(String blipId, PackagePart packagePart) {
        PackagePart blipPart;
        PackageRelationship blipRel = packagePart.getRelationship(blipId);
        try {
            blipPart = packagePart.getRelatedPart(blipRel);
        }
        catch (InvalidFormatException e) {
            throw new POIXMLException(e);
        }
        XSLFPictureData data = new XSLFPictureData(blipPart, null);
        XMLSlideShow ppt = this.getSlideShow();
        XSLFPictureData pictureData = ppt.addPicture(data.getData(), data.getType());
        PackagePart pic = pictureData.getPackagePart();
        PackageRelationship rel = this.getPackagePart().addRelationship(pic.getPartName(), TargetMode.INTERNAL, blipRel.getRelationshipType());
        this.addRelation(rel.getId(), new XSLFPictureData(pic, rel));
        return rel.getId();
    }

    PackagePart importPart(PackageRelationship srcRel, PackagePart srcPafrt) {
        PackagePart destPP = this.getPackagePart();
        PackagePartName srcPPName = srcPafrt.getPartName();
        OPCPackage pkg = destPP.getPackage();
        if (pkg.containPart(srcPPName)) {
            return pkg.getPart(srcPPName);
        }
        destPP.addRelationship(srcPPName, TargetMode.INTERNAL, srcRel.getRelationshipType());
        PackagePart part = pkg.createPart(srcPPName, srcPafrt.getContentType());
        try {
            OutputStream out = part.getOutputStream();
            InputStream is = srcPafrt.getInputStream();
            IOUtils.copy((InputStream)is, (OutputStream)out);
            is.close();
            out.close();
        }
        catch (IOException e) {
            throw new POIXMLException(e);
        }
        return part;
    }

    void removePictureRelation(XSLFPictureShape pictureShape) {
        POIXMLDocumentPart pd = this.getRelationById(pictureShape.getBlipId());
        this.removeRelation(pd);
    }
}

