/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal.impl;

import java.util.ArrayList;
import java.util.Iterator;
import javax.portlet.PreferencesValidator;
import javax.portlet.ValidatorException;
import javax.servlet.ServletContext;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.portlet.PortletDD;
import org.apache.pluto.descriptors.portlet.PortletPreferenceDD;
import org.apache.pluto.descriptors.portlet.PortletPreferencesDD;
import org.apache.pluto.internal.InternalPortletPreference;
import org.apache.pluto.internal.PortletDescriptorRegistry;
import org.apache.pluto.internal.PortletEntity;
import org.apache.pluto.internal.PreferencesValidatorRegistry;
import org.apache.pluto.internal.impl.PortletPreferenceImpl;

public class PortletEntityImpl
implements PortletEntity {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$pluto$internal$impl$PortletEntityImpl == null ? (class$org$apache$pluto$internal$impl$PortletEntityImpl = PortletEntityImpl.class$("org.apache.pluto.internal.impl.PortletEntityImpl")) : class$org$apache$pluto$internal$impl$PortletEntityImpl));
    private static final String PREFIX = "/PlutoInvoker/";
    private final ServletContext servletContext;
    private final String portletName;
    private PortletDD portletDefinition;
    private InternalPortletPreference[] defaultPreferences;
    static /* synthetic */ Class class$org$apache$pluto$internal$impl$PortletEntityImpl;

    PortletEntityImpl(ServletContext servletContext, String portletName) {
        this.servletContext = servletContext;
        this.portletName = portletName;
    }

    public String getControllerServletUri() {
        return PREFIX + this.portletName;
    }

    public InternalPortletPreference[] getDefaultPreferences() {
        PortletDD portletDD;
        PortletPreferencesDD prefsDD;
        if (this.defaultPreferences == null && (prefsDD = (portletDD = this.getPortletDefinition()).getPortletPreferences()) != null) {
            ArrayList<PortletPreferenceImpl> prefs = new ArrayList<PortletPreferenceImpl>();
            Iterator it = prefsDD.getPortletPreferences().iterator();
            while (it.hasNext()) {
                PortletPreferenceDD prefDD = (PortletPreferenceDD)it.next();
                String[] values = null;
                if (prefDD.getValues().size() > 0) {
                    values = prefDD.getValues().toArray(new String[prefDD.getValues().size()]);
                }
                PortletPreferenceImpl pref = new PortletPreferenceImpl(prefDD.getName(), values, prefDD.isReadOnly());
                prefs.add(pref);
            }
            this.defaultPreferences = prefs.toArray(new InternalPortletPreference[prefs.size()]);
        }
        return this.defaultPreferences;
    }

    public PortletDD getPortletDefinition() {
        if (this.portletDefinition == null) {
            this.load();
        }
        return this.portletDefinition;
    }

    public PreferencesValidator getPreferencesValidator() throws ValidatorException {
        PreferencesValidator validator = PreferencesValidatorRegistry.getRegistry().getPreferencesValidator(this.getPortletDefinition());
        return validator;
    }

    private void load() {
        ServletContext crossContext = this.servletContext;
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Retrieved cross context: " + crossContext));
        }
        try {
            PortletAppDD appDD = PortletDescriptorRegistry.getRegistry().getPortletAppDD(crossContext);
            Iterator it = appDD.getPortlets().iterator();
            while (it.hasNext()) {
                PortletDD portletDD = (PortletDD)it.next();
                if (!portletDD.getPortletName().equals(this.portletName)) continue;
                this.portletDefinition = portletDD;
                break;
            }
        }
        catch (PortletContainerException ex) {
            String message = "Unable to load Portlet App Deployment Descriptor:" + ex.getMessage();
            LOG.error((Object)message, (Throwable)ex);
            throw new NullPointerException(message);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

