/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pluto.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.WeakHashMap;
import javax.servlet.ServletContext;
import org.apache.pluto.PlutoConfigurationException;
import org.apache.pluto.PortletContainerException;
import org.apache.pluto.descriptors.portlet.PortletAppDD;
import org.apache.pluto.descriptors.services.PortletAppDescriptorService;
import org.apache.pluto.internal.Configuration;
import org.apache.pluto.util.StringManager;

public class PortletDescriptorRegistry {
    private static final String PORTLET_XML = "/WEB-INF/portlet.xml";
    private static final StringManager EXCEPTIONS = StringManager.getManager((class$org$apache$pluto$internal$PortletDescriptorRegistry == null ? (class$org$apache$pluto$internal$PortletDescriptorRegistry = PortletDescriptorRegistry.class$("org.apache.pluto.internal.PortletDescriptorRegistry")) : class$org$apache$pluto$internal$PortletDescriptorRegistry).getPackage().getName());
    private static final PortletDescriptorRegistry REGISTRY = new PortletDescriptorRegistry();
    private PortletAppDescriptorService portletDDService = null;
    private final Map cache = new WeakHashMap();
    static /* synthetic */ Class class$org$apache$pluto$internal$PortletDescriptorRegistry;

    public static PortletDescriptorRegistry getRegistry() {
        return REGISTRY;
    }

    private PortletDescriptorRegistry() throws PlutoConfigurationException {
        String className = Configuration.getPortletAppDescriptorServiceImpl();
        try {
            Class<?> clazz = Class.forName(className);
            this.portletDDService = (PortletAppDescriptorService)clazz.newInstance();
        }
        catch (ClassNotFoundException ex) {
            throw new PlutoConfigurationException("Unable to find class " + className, ex);
        }
        catch (InstantiationException ex) {
            throw new PlutoConfigurationException("Unable to instantiate class " + className, ex);
        }
        catch (IllegalAccessException ex) {
            throw new PlutoConfigurationException("Unable to access class " + className, ex);
        }
    }

    public PortletAppDD getPortletAppDD(ServletContext servletContext) throws PortletContainerException {
        PortletAppDD portletAppDD = (PortletAppDD)this.cache.get(servletContext);
        if (portletAppDD == null) {
            portletAppDD = this.createDefinition(servletContext);
            this.cache.put(servletContext, portletAppDD);
        }
        return portletAppDD;
    }

    private PortletAppDD createDefinition(ServletContext servletContext) throws PortletContainerException {
        PortletAppDD portletAppDD = null;
        try {
            InputStream in = servletContext.getResourceAsStream(PORTLET_XML);
            portletAppDD = this.portletDDService.read(in);
        }
        catch (IOException ex) {
            throw new PortletContainerException(EXCEPTIONS.getString("error.context.descriptor.load", new String[]{servletContext.getServletContextName()}), ex);
        }
        return portletAppDD;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

