/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdmodel;

import java.text.DateFormat;
import java.util.Calendar;
import java.util.List;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchemaBasic;
import org.apache.jempbox.xmp.XMPSchemaDublinCore;
import org.apache.jempbox.xmp.XMPSchemaPDF;
import org.apache.pdfbox.exceptions.CryptographyException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;

public class ExtractMetadata {
    private ExtractMetadata() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        if (args.length != 1) {
            ExtractMetadata.usage();
            System.exit(1);
        } else {
            PDDocument document = null;
            try {
                PDDocumentCatalog catalog;
                PDMetadata meta;
                document = PDDocument.load((String)args[0]);
                if (document.isEncrypted()) {
                    try {
                        document.decrypt("");
                    }
                    catch (CryptographyException e) {
                        e.printStackTrace();
                    }
                }
                if ((meta = (catalog = document.getDocumentCatalog()).getMetadata()) != null) {
                    XMPSchemaBasic basic;
                    XMPSchemaPDF pdf;
                    XMPMetadata metadata = meta.exportXMPMetadata();
                    XMPSchemaDublinCore dc = metadata.getDublinCoreSchema();
                    if (dc != null) {
                        ExtractMetadata.display("Title:", dc.getTitle());
                        ExtractMetadata.display("Description:", dc.getDescription());
                        ExtractMetadata.list("Creators: ", dc.getCreators());
                        ExtractMetadata.list("Dates:", dc.getDates());
                    }
                    if ((pdf = metadata.getPDFSchema()) != null) {
                        ExtractMetadata.display("Keywords:", pdf.getKeywords());
                        ExtractMetadata.display("PDF Version:", pdf.getPDFVersion());
                        ExtractMetadata.display("PDF Producer:", pdf.getProducer());
                    }
                    if ((basic = metadata.getBasicSchema()) != null) {
                        ExtractMetadata.display("Create Date:", basic.getCreateDate());
                        ExtractMetadata.display("Modify Date:", basic.getModifyDate());
                        ExtractMetadata.display("Creator Tool:", basic.getCreatorTool());
                    }
                } else {
                    PDDocumentInformation information = document.getDocumentInformation();
                    if (information != null) {
                        ExtractMetadata.showDocumentInformation(information);
                    }
                }
            }
            finally {
                if (document != null) {
                    document.close();
                }
            }
        }
    }

    private static void showDocumentInformation(PDDocumentInformation information) {
        ExtractMetadata.display("Title:", information.getTitle());
        ExtractMetadata.display("Subject:", information.getSubject());
        ExtractMetadata.display("Author:", information.getAuthor());
        ExtractMetadata.display("Creator:", information.getCreator());
        ExtractMetadata.display("Producer:", information.getProducer());
    }

    private static void list(String title, List list) {
        if (list == null) {
            return;
        }
        System.out.println(title);
        for (Object o : list) {
            System.out.println("  " + ExtractMetadata.format(o));
        }
    }

    private static String format(Object o) {
        if (o instanceof Calendar) {
            Calendar cal = (Calendar)o;
            return DateFormat.getDateInstance().format(cal.getTime());
        }
        return o.toString();
    }

    private static void display(String title, Object value) {
        if (value != null) {
            System.out.println(title + " " + ExtractMetadata.format(value));
        }
    }

    private static void usage() {
        System.err.println("Usage: java " + ExtractMetadata.class.getName() + " <input-pdf>");
    }
}

