/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.examples.pdfa;

import java.io.InputStream;
import org.apache.jempbox.xmp.XMPMetadata;
import org.apache.jempbox.xmp.XMPSchema;
import org.apache.jempbox.xmp.pdfa.XMPSchemaPDFAId;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.edit.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDTrueTypeFont;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;

public class CreatePDFA {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doIt(String file, String message) throws Exception {
        PDDocument doc = null;
        try {
            doc = new PDDocument();
            PDPage page = new PDPage();
            doc.addPage(page);
            InputStream fontStream = CreatePDFA.class.getResourceAsStream("/org/apache/pdfbox/resources/ttf/ArialMT.ttf");
            PDTrueTypeFont font = PDTrueTypeFont.loadTTF((PDDocument)doc, (InputStream)fontStream);
            PDPageContentStream contentStream = new PDPageContentStream(doc, page);
            contentStream.beginText();
            contentStream.setFont((PDFont)font, 12.0f);
            contentStream.moveTextPositionByAmount(100.0f, 700.0f);
            contentStream.drawString(message);
            contentStream.endText();
            contentStream.saveGraphicsState();
            contentStream.close();
            PDDocumentCatalog cat = doc.getDocumentCatalog();
            PDMetadata metadata = new PDMetadata(doc);
            cat.setMetadata(metadata);
            XMPMetadata xmp = new XMPMetadata();
            XMPSchemaPDFAId pdfaid = new XMPSchemaPDFAId(xmp);
            xmp.addSchema((XMPSchema)pdfaid);
            pdfaid.setConformance("B");
            pdfaid.setPart(Integer.valueOf(1));
            pdfaid.setAbout("");
            metadata.importXMPMetadata(xmp);
            InputStream colorProfile = CreatePDFA.class.getResourceAsStream("/org/apache/pdfbox/resources/pdfa/sRGB Color Space Profile.icm");
            PDOutputIntent oi = new PDOutputIntent(doc, colorProfile);
            oi.setInfo("sRGB IEC61966-2.1");
            oi.setOutputCondition("sRGB IEC61966-2.1");
            oi.setOutputConditionIdentifier("sRGB IEC61966-2.1");
            oi.setRegistryName("http://www.color.org");
            cat.addOutputIntent(oi);
            doc.save(file);
        }
        finally {
            if (doc != null) {
                doc.close();
            }
        }
    }

    public static void main(String[] args) {
        CreatePDFA app = new CreatePDFA();
        try {
            if (args.length != 2) {
                app.usage();
            } else {
                app.doIt(args[0], args[1]);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void usage() {
        System.err.println("usage: " + this.getClass().getName() + " <output-file> <Message>");
    }
}

