/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.sentdetect;

import java.io.IOException;
import opennlp.tools.cmdline.AbstractEvaluatorTool;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.params.EvaluatorParams;
import opennlp.tools.cmdline.sentdetect.SentenceEvaluationErrorListener;
import opennlp.tools.cmdline.sentdetect.SentenceModelLoader;
import opennlp.tools.sentdetect.SentenceDetectorEvaluator;
import opennlp.tools.sentdetect.SentenceDetectorME;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;

public final class SentenceDetectorEvaluatorTool
extends AbstractEvaluatorTool<SentenceSample, EvalToolParams> {
    public SentenceDetectorEvaluatorTool() {
        super(SentenceSample.class, EvalToolParams.class);
    }

    @Override
    public String getShortDescription() {
        return "evaluator for the learnable sentence detector";
    }

    @Override
    public void run(String format, String[] args) {
        super.run(format, args);
        SentenceModel model = (SentenceModel)new SentenceModelLoader().load(((EvalToolParams)this.params).getModel());
        SentenceEvaluationErrorListener errorListener = null;
        if (((EvalToolParams)this.params).getMisclassified().booleanValue()) {
            errorListener = new SentenceEvaluationErrorListener();
        }
        SentenceDetectorEvaluator evaluator = new SentenceDetectorEvaluator(new SentenceDetectorME(model), errorListener);
        System.out.print("Evaluating ... ");
        try {
            evaluator.evaluate(this.sampleStream);
        }
        catch (IOException e) {
            throw new TerminateToolException(-1, "IO error while reading training data or indexing data: " + e.getMessage(), e);
        }
        finally {
            try {
                this.sampleStream.close();
            }
            catch (IOException iOException) {}
        }
        System.err.println("done");
        System.out.println();
        System.out.println(evaluator.getFMeasure());
    }

    static interface EvalToolParams
    extends EvaluatorParams {
    }
}

