/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openjpa.persistence.jest;

import java.io.BufferedReader;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.metamodel.Attribute;
import javax.persistence.metamodel.Metamodel;
import org.apache.openjpa.kernel.OpenJPAStateManager;
import org.apache.openjpa.kernel.StoreContext;
import org.apache.openjpa.meta.FieldMetaData;
import org.apache.openjpa.persistence.jest.JPAServletContext;
import org.apache.openjpa.persistence.jest.JSON;
import org.apache.openjpa.persistence.jest.JSONObject;
import org.apache.openjpa.persistence.jest.MetamodelHelper;
import org.apache.openjpa.persistence.jest.ObjectFormatter;
import org.apache.openjpa.persistence.jest.ProcessingException;
import org.apache.openjpa.persistence.meta.Members;

public class JSONObjectFormatter
implements ObjectFormatter<JSON> {
    @Override
    public String getMimeType() {
        return "application/json";
    }

    public void encode(Object obj, JPAServletContext ctx) {
        if (obj instanceof OpenJPAStateManager) {
            try {
                JSON result = this.encodeManagedInstance((OpenJPAStateManager)obj, ctx.getPersistenceContext().getMetamodel());
                PrintWriter writer = ctx.getResponse().getWriter();
                writer.println(result.toString());
            }
            catch (Exception e) {
                throw new ProcessingException(ctx, (Throwable)e);
            }
        } else {
            throw new RuntimeException(this + " does not know how to encode " + obj);
        }
    }

    @Override
    public JSON writeOut(Collection<OpenJPAStateManager> sms, Metamodel model, String title, String desc, String uri, OutputStream out) throws IOException {
        Object json = this.encode((Collection)sms, model);
        out.write(json.toString().getBytes());
        return json;
    }

    @Override
    public JSON encode(Collection<OpenJPAStateManager> sms, Metamodel model) {
        return this.encodeManagedInstances(sms, model);
    }

    private JSON encodeManagedInstance(OpenJPAStateManager sm, Metamodel model) {
        return this.encodeManagedInstance(sm, new HashSet<OpenJPAStateManager>(), 0, false, model);
    }

    private JSON encodeManagedInstances(Collection<OpenJPAStateManager> sms, Metamodel model) {
        JSONObject.Array result = new JSONObject.Array();
        for (OpenJPAStateManager sm : sms) {
            result.add(this.encodeManagedInstance(sm, new HashSet<OpenJPAStateManager>(), 0, false, model));
        }
        return result;
    }

    private JSONObject encodeManagedInstance(OpenJPAStateManager sm, Set<OpenJPAStateManager> visited, int indent, boolean indentPara, Metamodel model) {
        if (visited == null) {
            throw new IllegalArgumentException("null closure for encoder");
        }
        if (sm == null) {
            return null;
        }
        boolean ref = !visited.add(sm);
        JSONObject root = new JSONObject(this.typeOf(sm), sm.getObjectId(), ref);
        if (ref) {
            return root;
        }
        BitSet loaded = sm.getLoaded();
        StoreContext ctx = (StoreContext)sm.getGenericContext();
        List<Attribute<?, ?>> attrs = MetamodelHelper.getAttributesInOrder(sm.getMetaData(), model);
        block9: for (int i = 0; i < attrs.size(); ++i) {
            FieldMetaData fmd = ((Members.Member)attrs.get((int)i)).fmd;
            if (!loaded.get(fmd.getIndex())) continue;
            List<Object> value = sm.fetch(fmd.getIndex());
            switch (fmd.getDeclaredTypeCode()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 9: 
                case 10: 
                case 14: 
                case 16: 
                case 17: 
                case 18: 
                case 19: 
                case 20: 
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 26: 
                case 28: 
                case 32: {
                    root.set(fmd.getName(), value);
                    continue block9;
                }
                case 15: {
                    if (value == null) {
                        root.set(fmd.getName(), null);
                        continue block9;
                    }
                    root.set(fmd.getName(), this.encodeManagedInstance(ctx.getStateManager(value), visited, indent + 1, false, model));
                    continue block9;
                }
                case 11: {
                    Object[] values = (Object[])value;
                    value = Arrays.asList(values);
                }
                case 12: {
                    if (value == null) {
                        root.set(fmd.getName(), null);
                        continue block9;
                    }
                    Collection members = value;
                    JSONObject.Array array = new JSONObject.Array();
                    root.set(fmd.getName(), array);
                    if (members.isEmpty()) continue block9;
                    boolean basic = fmd.getElement().getTypeMetaData() == null;
                    for (Object o : members) {
                        if (o == null) {
                            array.add(null);
                            continue;
                        }
                        if (basic) {
                            array.add(o);
                            continue;
                        }
                        array.add(this.encodeManagedInstance(ctx.getStateManager(o), visited, indent + 1, true, model));
                    }
                    continue block9;
                }
                case 13: {
                    if (value == null) {
                        root.set(fmd.getName(), null);
                        continue block9;
                    }
                    Set entries = ((Map)((Object)value)).entrySet();
                    JSONObject.KVMap map = new JSONObject.KVMap();
                    root.set(fmd.getName(), map);
                    if (entries.isEmpty()) continue block9;
                    boolean basicKey = fmd.getElement().getTypeMetaData() == null;
                    boolean basicValue = fmd.getValue().getTypeMetaData() == null;
                    for (Map.Entry e : entries) {
                        Object k = e.getKey();
                        Object v = e.getValue();
                        if (!basicKey) {
                            k = this.encodeManagedInstance(ctx.getStateManager(k), visited, indent + 1, true, model);
                        }
                        if (!basicValue) {
                            v = this.encodeManagedInstance(ctx.getStateManager(e.getValue()), visited, indent + 1, false, model);
                        }
                        map.put(k, v);
                    }
                    continue block9;
                }
                case 30: 
                case 31: {
                    root.set(fmd.getName(), this.streamToString(value));
                    continue block9;
                }
                case 8: 
                case 27: 
                case 29: {
                    root.set(fmd.getName(), "***UNSUPPORTED***");
                }
            }
        }
        return root;
    }

    String typeOf(OpenJPAStateManager sm) {
        return sm.getMetaData().getDescribedType().getSimpleName();
    }

    String streamToString(Object value) {
        Reader reader = null;
        if (value instanceof InputStream) {
            reader = new BufferedReader(new InputStreamReader((InputStream)value));
        } else if (value instanceof Reader) {
            reader = (Reader)value;
        } else {
            throw new RuntimeException();
        }
        CharArrayWriter writer = new CharArrayWriter();
        try {
            int c;
            while ((c = reader.read()) != -1) {
                writer.write(c);
            }
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
        return writer.toString();
    }

    @Override
    public JSON encode(Metamodel model) {
        return null;
    }

    @Override
    public JSON writeOut(Metamodel model, String title, String desc, String uri, OutputStream out) throws IOException {
        throw new UnsupportedOperationException();
    }
}

