/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.loader;

import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Pattern;

public class Files {
    static final List<String> delete = new ArrayList<String>();

    public static File path(String ... parts) {
        File dir = null;
        for (String part : parts) {
            dir = dir == null ? new File(part) : new File(dir, part);
        }
        return dir;
    }

    public static File path(File dir, String ... parts) {
        for (String part : parts) {
            dir = new File(dir, part);
        }
        return dir;
    }

    public static List<File> collect(File dir, String regex) {
        return Files.collect(dir, Pattern.compile(regex));
    }

    public static List<File> collect(File dir, final Pattern pattern) {
        return Files.collect(dir, new FileFilter(){

            @Override
            public boolean accept(File file) {
                return pattern.matcher(file.getName()).matches();
            }
        });
    }

    public static List<File> collect(File dir, FileFilter filter) {
        File[] files;
        ArrayList<File> accepted = new ArrayList<File>();
        if (filter.accept(dir)) {
            accepted.add(dir);
        }
        if ((files = dir.listFiles()) != null) {
            for (File file : files) {
                accepted.addAll(Files.collect(file, filter));
            }
        }
        return accepted;
    }

    public static File exists(File file, String s) {
        if (!file.exists()) {
            throw new FileRuntimeException(s + " does not exist: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File exists(File file) {
        if (!file.exists()) {
            throw new FileRuntimeException("Does not exist: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File dir(File file) {
        if (!file.isDirectory()) {
            throw new FileRuntimeException("Not a directory: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File file(File file) {
        Files.exists(file);
        if (!file.isFile()) {
            throw new FileRuntimeException("Not a file: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File writable(File file) {
        if (!file.canWrite()) {
            throw new FileRuntimeException("Not writable: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File readable(File file) {
        if (!file.canRead()) {
            throw new FileRuntimeException("Not readable: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File readableFile(File file) {
        return Files.readable(Files.file(file));
    }

    public static File mkdir(File file) {
        if (file.exists()) {
            return file;
        }
        if (!file.mkdirs()) {
            throw new FileRuntimeException("Cannot mkdir: " + file.getAbsolutePath());
        }
        return file;
    }

    public static File tmpdir() {
        try {
            File file = File.createTempFile("temp", "dir");
            if (!file.delete()) {
                throw new IllegalStateException("Cannot make temp dir.  Delete failed");
            }
            Files.mkdir(file);
            Files.deleteOnExit(file);
            return file;
        }
        catch (IOException e) {
            throw new FileRuntimeException(e);
        }
    }

    public static File mkparent(File file) {
        Files.mkdirs(file.getParentFile());
        return file;
    }

    public static File mkdirs(File file) {
        if (!file.exists()) {
            if (!file.mkdirs()) {
                throw new FileRuntimeException("Cannot mkdirs: " + file.getAbsolutePath());
            }
            return file;
        }
        return Files.dir(file);
    }

    public static void deleteOnExit(File file) {
        delete.add(file.getAbsolutePath());
    }

    private static void delete() {
        for (String path : delete) {
            Files.delete(new File(path));
        }
    }

    public static void delete(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                for (File f : file.listFiles()) {
                    Files.delete(f);
                }
            }
            file.delete();
        }
    }

    public static File select(File dir, String pattern) {
        List<File> matches = Files.collect(dir, pattern);
        if (matches.size() == 0) {
            throw new IllegalStateException(String.format("Missing '%s'", pattern));
        }
        if (matches.size() > 1) {
            throw new IllegalStateException(String.format("Too many found '%s': %s", pattern, Files.join(", ", matches)));
        }
        return matches.get(0);
    }

    private static String join(String delimiter, Collection<File> collection) {
        if (collection.size() == 0) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (File obj : collection) {
            sb.append(obj.getName()).append(delimiter);
        }
        return sb.substring(0, sb.length() - delimiter.length());
    }

    static {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Files.delete();
            }
        });
    }

    public static class FileRuntimeException
    extends RuntimeException {
        public FileRuntimeException(String str) {
            super(str);
        }

        public FileRuntimeException(Exception e) {
            super(e);
        }
    }
}

