/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.util;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import javax.faces.context.ExternalContext;
import javax.servlet.ServletContext;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;
import org.apache.myfaces.trinidad.util.ClassLoaderUtils;
import org.apache.myfaces.trinidad.util.RequestType;

public final class ExternalContextUtils {
    private static final TrinidadLogger _LOG;
    private static final Class<?> _PORTLET_ACTION_REQUEST_CLASS;
    private static final Class<?> _PORTLET_RENDER_REQUEST_CLASS;
    private static final Class<?> _PORTLET_RESOURCE_REQUEST_CLASS;
    private static final Class<?> _PORTLET_CONTEXT_CLASS;
    private static final boolean _PORTLET_10_SUPPORTED;
    private static final boolean _PORTLET_20_SUPPORTED;

    public static final boolean isRequestTypeAvailable(RequestType type) {
        switch (type) {
            case SERVLET: {
                return true;
            }
            case ACTION: 
            case RENDER: {
                return _PORTLET_CONTEXT_CLASS != null;
            }
            case RESOURCE: 
            case EVENT: {
                return _PORTLET_RENDER_REQUEST_CLASS != null;
            }
        }
        return false;
    }

    public static final boolean isRequestTypeSupported(RequestType type) {
        switch (type) {
            case SERVLET: {
                return true;
            }
            case ACTION: 
            case RENDER: {
                return _PORTLET_10_SUPPORTED;
            }
            case RESOURCE: 
            case EVENT: {
                return _PORTLET_20_SUPPORTED;
            }
        }
        return false;
    }

    public static final RequestType getRequestType(ExternalContext ec) {
        if (_PORTLET_10_SUPPORTED && _PORTLET_CONTEXT_CLASS.isInstance(ec.getContext())) {
            Object request = ec.getRequest();
            if (_PORTLET_RENDER_REQUEST_CLASS.isInstance(request)) {
                return RequestType.RENDER;
            }
            if (_PORTLET_RESOURCE_REQUEST_CLASS != null) {
                if (_PORTLET_ACTION_REQUEST_CLASS.isInstance(request)) {
                    return RequestType.ACTION;
                }
                if (_PORTLET_RESOURCE_REQUEST_CLASS.isInstance(request)) {
                    return RequestType.RESOURCE;
                }
                return RequestType.EVENT;
            }
            return RequestType.ACTION;
        }
        return RequestType.SERVLET;
    }

    public static String getSessionId(ExternalContext ec) {
        return ExternalContextUtils.getSessionId(ec, true);
    }

    public static String getSessionId(ExternalContext ec, boolean create) {
        Object session = ec.getSession(create);
        return null != session ? (String)ExternalContextUtils._runMethod(session, "getId") : null;
    }

    public static String getRequestedSessionId(ExternalContext ec) {
        return (String)ExternalContextUtils._runMethod(ec.getRequest(), "getRequestedSessionId");
    }

    public static boolean isRequestedSessionIdValid(ExternalContext ec) {
        return (Boolean)ExternalContextUtils._runMethod(ec.getRequest(), "isRequestedSessionIdValid");
    }

    public static String getServletContextPath(ExternalContext ec) {
        if (!ExternalContextUtils.isPortlet(ec)) {
            return ((ServletContext)ec.getContext()).getContextPath();
        }
        return null;
    }

    @Deprecated
    public static String getRequestContextPath(ExternalContext ec) {
        if (!ExternalContextUtils.isPortlet(ec)) {
            return ec.getRequestContextPath();
        }
        return null;
    }

    public static String getRequestURI(ExternalContext ec) {
        if (!ExternalContextUtils.isPortlet(ec)) {
            return ((HttpServletRequest)ec.getRequest()).getRequestURI();
        }
        return null;
    }

    @Deprecated
    public static String getCharacterEncoding(ExternalContext ec) {
        return ec.getRequestCharacterEncoding();
    }

    public static String getContextName(ExternalContext ec) {
        try {
            if (ExternalContextUtils.isPortlet(ec)) {
                return (String)ExternalContextUtils._runMethod(ec.getContext(), "getPortletContextName");
            }
            return ((ServletContext)ec.getContext()).getServletContextName();
        }
        catch (ClassCastException e) {
            _LOG.severe(e);
            return null;
        }
    }

    public static int getContentLength(ExternalContext ec) {
        if (ExternalContextUtils.isRequestFromClient(ec)) {
            return (Integer)ExternalContextUtils._runMethod(ec.getRequest(), "getContentLength");
        }
        return -1;
    }

    @Deprecated
    public static String getContentType(ExternalContext ec) {
        return ec.getRequestContentType();
    }

    public static InputStream getRequestInputStream(ExternalContext ec) throws IOException {
        RequestType type = ExternalContextUtils.getRequestType(ec);
        if (type.isRequestFromClient()) {
            Object req = ec.getRequest();
            if (type.isPortlet()) {
                return (InputStream)ExternalContextUtils._runMethod(req, "getPortletInputStream");
            }
            return ((ServletRequest)ec.getRequest()).getInputStream();
        }
        return null;
    }

    @Deprecated
    public static boolean isAction(ExternalContext ec) {
        return ExternalContextUtils.isRequestFromClient(ec);
    }

    public static boolean isPortlet(ExternalContext ec) {
        return ExternalContextUtils.getRequestType(ec).isPortlet();
    }

    public static final boolean isResponseWritable(ExternalContext ec) {
        return ExternalContextUtils.getRequestType(ec).isResponseWritable();
    }

    public static final boolean isRequestFromClient(ExternalContext ec) {
        return ExternalContextUtils.getRequestType(ec).isRequestFromClient();
    }

    public static boolean isHttpServletRequest(ExternalContext ec) {
        return !ExternalContextUtils.isPortlet(ec) && ec.getRequest() instanceof HttpServletRequest;
    }

    private static Object _runMethod(Object obj, String methodName) {
        try {
            Method sessionIdMethod = obj.getClass().getMethod(methodName, new Class[0]);
            return sessionIdMethod.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            return null;
        }
    }

    private ExternalContextUtils() {
    }

    static {
        Class<?> resourceRequest;
        Class<?> renderRequest;
        Class<?> actionRequest;
        Class<?> context;
        _LOG = TrinidadLogger.createTrinidadLogger(ExternalContextUtils.class);
        boolean portlet20Supported = false;
        boolean portlet10Supported = false;
        try {
            context = ClassLoaderUtils.loadClass("javax.portlet.PortletContext");
            actionRequest = ClassLoaderUtils.loadClass("javax.portlet.ActionRequest");
            renderRequest = ClassLoaderUtils.loadClass("javax.portlet.RenderRequest");
            try {
                resourceRequest = ClassLoaderUtils.loadClass("javax.portlet.ResourceRequest");
            }
            catch (ClassNotFoundException e) {
                _LOG.fine("Portlet 2.0 API is not available on classpath.  Portlet 2.0 functionality is disabled");
                resourceRequest = null;
            }
        }
        catch (ClassNotFoundException e) {
            _LOG.fine("Portlet API is not available on the classpath.  Portlet configurations are disabled.");
            context = null;
            actionRequest = null;
            renderRequest = null;
            resourceRequest = null;
        }
        if (context != null) {
            try {
                Class<?> bridge = ClassLoaderUtils.loadClass("javax.portlet.faces.Bridge");
                if (bridge != null) {
                    portlet10Supported = true;
                    String specName = bridge.getPackage().getSpecificationTitle();
                    _LOG.fine("Found Bridge: " + specName);
                    if (specName != null && specName.startsWith("Portlet 2")) {
                        portlet20Supported = true;
                    }
                    if (_LOG.isInfo()) {
                        String ver = portlet20Supported ? "2.0" : "1.0";
                        _LOG.info("Portlet Environment Detected: " + ver);
                    }
                }
            }
            catch (ClassNotFoundException e) {
                _LOG.fine("Portlet API is present but bridge is not.  Portlet configurations are disabled.");
            }
        }
        _PORTLET_CONTEXT_CLASS = context;
        _PORTLET_ACTION_REQUEST_CLASS = actionRequest;
        _PORTLET_RENDER_REQUEST_CLASS = renderRequest;
        _PORTLET_RESOURCE_REQUEST_CLASS = resourceRequest;
        _PORTLET_10_SUPPORTED = portlet10Supported;
        _PORTLET_20_SUPPORTED = portlet20Supported;
    }
}

