/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.model;

import java.util.HashMap;
import java.util.Map;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import org.apache.myfaces.trinidad.model.MenuModel;

public class ProcessUtils {
    private static final Object _MAX_PATH_TOP = new Object();

    public static boolean isImmediate(MenuModel model, boolean defaultReturnValue) {
        Object currPath;
        Object focusPath = model.getFocusRowKey();
        boolean returnDefault = ProcessUtils._hasDifferentAncestors(model, focusPath, currPath = model.getRowKey());
        if (returnDefault) {
            model.setRowKey(currPath);
            return defaultReturnValue;
        }
        model.setRowKey(focusPath);
        int focusIndex = model.getRowIndex();
        model.setRowKey(currPath);
        int currIndex = model.getRowIndex();
        return currIndex < focusIndex;
    }

    public static boolean isReadOnly(MenuModel model, boolean defaultReturnValue) {
        Object currPath;
        Object focusPath = model.getFocusRowKey();
        boolean returnDefault = ProcessUtils._hasDifferentAncestors(model, focusPath, currPath = model.getRowKey());
        if (returnDefault) {
            model.setRowKey(currPath);
            return defaultReturnValue;
        }
        if (focusPath.equals(currPath)) {
            model.setRowKey(currPath);
            return true;
        }
        model.setRowKey(focusPath);
        int focusIndex = model.getRowIndex();
        model.setRowKey(currPath);
        int currIndex = model.getRowIndex();
        return currIndex > focusIndex + 1;
    }

    private static boolean _hasDifferentAncestors(MenuModel model, Object key1, Object key2) {
        if (key1 == null || key2 == null) {
            return true;
        }
        int depth = model.getDepth(key2);
        if (depth != model.getDepth(key1)) {
            return true;
        }
        if (depth > 0) {
            model.setRowKey(key1);
            Object key1ParentPath = model.getContainerRowKey();
            model.setRowKey(key2);
            Object key2ParentPath = model.getContainerRowKey();
            if (!key2ParentPath.equals(key1ParentPath)) {
                return true;
            }
        }
        return false;
    }

    public static boolean isImmediate(MenuModel model, Object maxVisitedRowKey, boolean defaultReturnValue) {
        Object currPath;
        Object focusPath = model.getFocusRowKey();
        boolean returnDefault = ProcessUtils._hasDifferentAncestors(model, focusPath, currPath = model.getRowKey(), maxVisitedRowKey);
        if (returnDefault) {
            model.setRowKey(currPath);
            return defaultReturnValue;
        }
        model.setRowKey(focusPath);
        int focusIndex = model.getRowIndex();
        model.setRowKey(maxVisitedRowKey);
        int maxIndex = model.getRowIndex();
        model.setRowKey(currPath);
        int currIndex = model.getRowIndex();
        return maxIndex == focusIndex && currIndex < focusIndex;
    }

    public static boolean isReadOnly(MenuModel model, Object maxVisitedRowKey, boolean defaultReturnValue) {
        Object currPath;
        Object focusPath = model.getFocusRowKey();
        boolean returnDefault = ProcessUtils._hasDifferentAncestors(model, focusPath, currPath = model.getRowKey(), maxVisitedRowKey);
        if (returnDefault) {
            model.setRowKey(currPath);
            return defaultReturnValue;
        }
        if (focusPath.equals(currPath)) {
            model.setRowKey(currPath);
            return true;
        }
        model.setRowKey(focusPath);
        int focusIndex = model.getRowIndex();
        model.setRowKey(maxVisitedRowKey);
        int maxIndex = model.getRowIndex();
        if (maxIndex == focusIndex) {
            ++maxIndex;
        }
        model.setRowKey(currPath);
        int currIndex = model.getRowIndex();
        return currIndex > maxIndex;
    }

    public static boolean isVisited(MenuModel model, boolean defaultReturnValue) {
        Object currPath;
        Object focusPath = model.getFocusRowKey();
        boolean returnDefault = ProcessUtils._hasDifferentAncestors(model, focusPath, currPath = model.getRowKey());
        if (returnDefault) {
            model.setRowKey(currPath);
            return defaultReturnValue;
        }
        if (focusPath.equals(currPath)) {
            model.setRowKey(currPath);
            return true;
        }
        model.setRowKey(focusPath);
        int focusIndex = model.getRowIndex();
        model.setRowKey(currPath);
        int currIndex = model.getRowIndex();
        return currIndex <= focusIndex;
    }

    public static boolean isVisited(MenuModel model, Object maxVisitedRowKey, boolean defaultReturnValue) {
        Object currPath;
        Object focusPath = model.getFocusRowKey();
        boolean returnDefault = ProcessUtils._hasDifferentAncestors(model, focusPath, currPath = model.getRowKey(), maxVisitedRowKey);
        if (returnDefault) {
            model.setRowKey(currPath);
            return defaultReturnValue;
        }
        if (focusPath.equals(currPath)) {
            model.setRowKey(currPath);
            return true;
        }
        model.setRowKey(maxVisitedRowKey);
        int maxIndex = model.getRowIndex();
        model.setRowKey(currPath);
        int currIndex = model.getRowIndex();
        return currIndex <= maxIndex;
    }

    public static Object getMaxVisitedRowKey(MenuModel model, String maxPathKey) {
        ExternalContext externalContext = FacesContext.getCurrentInstance().getExternalContext();
        Map requestMap = externalContext.getRequestMap();
        Object maxPath = requestMap.get(maxPathKey);
        if (maxPath == null) {
            Object focusRowKey;
            Object parentRowKey;
            Map sessionMap = externalContext.getSessionMap();
            HashMap<Object, Object> maxPathMap = (HashMap<Object, Object>)sessionMap.get(maxPathKey);
            if (maxPathMap == null) {
                maxPathMap = new HashMap<Object, Object>();
            }
            if ((parentRowKey = model.getContainerRowKey(focusRowKey = model.getFocusRowKey())) == null) {
                parentRowKey = _MAX_PATH_TOP;
            }
            if ((maxPath = maxPathMap.get(parentRowKey)) == null) {
                maxPath = model.getFocusRowKey();
                maxPathMap.put(parentRowKey, maxPath);
                sessionMap.put(maxPathKey, maxPathMap);
                requestMap.put(maxPathKey, maxPath);
            } else {
                Object currPath = model.getRowKey();
                Object focusPath = model.getFocusRowKey();
                boolean hasDifferentAncestors = ProcessUtils._hasDifferentAncestors(model, focusPath, maxPath);
                if (hasDifferentAncestors) {
                    model.setRowKey(currPath);
                    return null;
                }
                model.setRowKey(focusPath);
                int focusRowIndex = model.getRowIndex();
                model.setRowKey(maxPath);
                int maxRowIndex = model.getRowIndex();
                if (focusRowIndex > maxRowIndex) {
                    maxPathMap.put(parentRowKey, focusPath);
                    sessionMap.put(maxPathKey, maxPathMap);
                    requestMap.put(maxPathKey, focusPath);
                } else {
                    requestMap.put(maxPathKey, maxPath);
                }
                model.setRowKey(currPath);
            }
        }
        return maxPath;
    }

    public static void clearMaxPath(String maxPathKey) {
        if (maxPathKey != null) {
            Map sessionMap = FacesContext.getCurrentInstance().getExternalContext().getSessionMap();
            sessionMap.put(maxPathKey, null);
        }
    }

    private static boolean _hasDifferentAncestors(MenuModel model, Object key1, Object key2, Object key3) {
        boolean diff1 = ProcessUtils._hasDifferentAncestors(model, key1, key2);
        if (diff1) {
            return true;
        }
        boolean diff2 = ProcessUtils._hasDifferentAncestors(model, key1, key3);
        return diff2;
    }
}

