/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.trinidad.change;

import java.util.HashMap;
import javax.el.ValueExpression;
import javax.faces.component.NamingContainer;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.myfaces.trinidad.change.AttributeComponentChange;
import org.apache.myfaces.trinidad.change.AttributeDocumentChange;
import org.apache.myfaces.trinidad.change.ComponentChange;
import org.apache.myfaces.trinidad.change.DocumentChange;
import org.apache.myfaces.trinidad.change.DocumentChangeFactory;
import org.apache.myfaces.trinidad.logging.TrinidadLogger;

public abstract class ChangeManager {
    private static HashMap<String, String> _CLASSNAME_TO_CONVERTER_NAME_MAP = new HashMap();
    private static HashMap<Class<? extends ComponentChange>, DocumentChangeFactory> _CLASS_TO_CONVERTER_MAP = new HashMap();
    private static final TrinidadLogger _LOG = TrinidadLogger.createTrinidadLogger(ChangeManager.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerDocumentFactory(String targetClassName, String converterClassName) {
        if (targetClassName == null || targetClassName.length() == 0) {
            throw new IllegalArgumentException(_LOG.getMessage("TARGET_CLASS_NAME_MUST_BE_PROVIDED"));
        }
        if (converterClassName == null || converterClassName.length() == 0) {
            throw new IllegalArgumentException(_LOG.getMessage("CONVERTER_CLASS_NAME_MUST_BE_PROVIDED"));
        }
        HashMap<String, String> hashMap = _CLASSNAME_TO_CONVERTER_NAME_MAP;
        synchronized (hashMap) {
            _CLASSNAME_TO_CONVERTER_NAME_MAP.put(targetClassName, converterClassName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static DocumentChange createDocumentChange(ComponentChange change) {
        Class<?> changeClass = change.getClass();
        DocumentChangeFactory converterObject = null;
        DocumentChangeFactory converter = null;
        HashMap<Class<? extends ComponentChange>, DocumentChangeFactory> hashMap = _CLASS_TO_CONVERTER_MAP;
        synchronized (hashMap) {
            converterObject = _CLASS_TO_CONVERTER_MAP.get(changeClass);
        }
        if (converterObject != null) {
            converter = converterObject;
        } else {
            String converterName = null;
            HashMap<String, String> hashMap2 = _CLASSNAME_TO_CONVERTER_NAME_MAP;
            synchronized (hashMap2) {
                converterName = _CLASSNAME_TO_CONVERTER_NAME_MAP.get(changeClass.getName());
            }
            if (converterName != null) {
                block17: {
                    try {
                        ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
                        Class<?> converterClass = contextClassLoader.loadClass(converterName);
                        if (DocumentChangeFactory.class.isAssignableFrom(converterClass)) {
                            converter = (DocumentChangeFactory)converterClass.newInstance();
                            HashMap<Class<? extends ComponentChange>, DocumentChangeFactory> hashMap3 = _CLASS_TO_CONVERTER_MAP;
                            synchronized (hashMap3) {
                                _CLASS_TO_CONVERTER_MAP.put(changeClass, converter);
                                break block17;
                            }
                        }
                        _LOG.warning("CONVERSION_CLASS_TYPE", new Object[]{converterClass, DocumentChangeFactory.class});
                    }
                    catch (Throwable e) {
                        _LOG.warning("UNABLE_INSTANTIATE_CONVERTERCLASS", converterName);
                        _LOG.warning(e);
                    }
                }
                if (converter == null) {
                    _CLASSNAME_TO_CONVERTER_NAME_MAP.remove(converterName);
                    return null;
                }
            }
        }
        if (converter != null) {
            return converter.convert(change);
        }
        return null;
    }

    public abstract void addComponentChange(FacesContext var1, UIComponent var2, ComponentChange var3);

    public void addDocumentChange(FacesContext facesContext, UIComponent uiComponent, DocumentChange change) {
        if (facesContext == null || uiComponent == null || change == null) {
            throw new IllegalArgumentException(_LOG.getMessage("CANNOT_ADD_CHANGE_WITH_FACECONTEXT_OR_UICOMPONENT_OR_NULL"));
        }
    }

    public void applyComponentChangesForCurrentView(FacesContext facesContext) {
        throw new UnsupportedOperationException("Subclassers must implement");
    }

    public void applyComponentChangesForSubtree(FacesContext facesContext, NamingContainer root) {
        throw new UnsupportedOperationException("Subclassers must implement");
    }

    static {
        _CLASS_TO_CONVERTER_MAP.put(AttributeComponentChange.class, new AttributeConverter());
    }

    private static class AttributeConverter
    extends DocumentChangeFactory {
        private AttributeConverter() {
        }

        public DocumentChange convert(ComponentChange compChange) {
            if (compChange instanceof AttributeComponentChange) {
                AttributeComponentChange change = (AttributeComponentChange)compChange;
                Object value = change.getAttributeValue();
                String valueString = null;
                if (value == null || value instanceof CharSequence || value instanceof Number || value instanceof Boolean) {
                    valueString = value != null ? value.toString() : null;
                } else if (value instanceof ValueExpression) {
                    valueString = ((ValueExpression)value).getExpressionString();
                } else if (value instanceof ValueBinding) {
                    valueString = ((ValueBinding)value).getExpressionString();
                }
                if (valueString != null) {
                    return new AttributeDocumentChange(change.getAttributeName(), valueString);
                }
            }
            return null;
        }
    }
}

