/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.api.testset;

import java.io.File;
import org.apache.maven.surefire.api.util.RunOrder;

public class RunOrderParameters {
    private final RunOrder[] runOrder;
    private File runStatisticsFile;
    private Long runOrderRandomSeed;

    public RunOrderParameters(RunOrder[] runOrder, File runStatisticsFile) {
        this.runOrder = runOrder;
        this.runStatisticsFile = runStatisticsFile;
        this.runOrderRandomSeed = null;
    }

    public RunOrderParameters(String runOrder, File runStatisticsFile) {
        this.runOrder = runOrder == null ? RunOrder.DEFAULT : RunOrder.valueOfMulti(runOrder);
        this.runStatisticsFile = runStatisticsFile;
        this.runOrderRandomSeed = null;
    }

    public RunOrderParameters(RunOrder[] runOrder, File runStatisticsFile, Long runOrderRandomSeed) {
        this.runOrder = runOrder;
        this.runStatisticsFile = runStatisticsFile;
        this.runOrderRandomSeed = runOrderRandomSeed;
    }

    public RunOrderParameters(String runOrder, File runStatisticsFile, Long runOrderRandomSeed) {
        this.runOrder = runOrder == null ? RunOrder.DEFAULT : RunOrder.valueOfMulti(runOrder);
        this.runStatisticsFile = runStatisticsFile;
        this.runOrderRandomSeed = runOrderRandomSeed;
    }

    public static RunOrderParameters alphabetical() {
        return new RunOrderParameters(new RunOrder[]{RunOrder.ALPHABETICAL}, null);
    }

    public RunOrder[] getRunOrder() {
        return this.runOrder;
    }

    public Long getRunOrderRandomSeed() {
        return this.runOrderRandomSeed;
    }

    public void setRunOrderRandomSeed(Long runOrderRandomSeed) {
        this.runOrderRandomSeed = runOrderRandomSeed;
    }

    public File getRunStatisticsFile() {
        return this.runStatisticsFile;
    }
}

