/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.assertion;

import org.apache.maven.surefire.assertion.SurefireAssert;
import org.apache.maven.surefire.assertion.SurefireAssertionFailedException;

public class SurefireComparisonFailureException
extends SurefireAssertionFailedException {
    private final String expected;
    private final String actual;

    public SurefireComparisonFailureException(String message, String expected, String actual) {
        super(message);
        this.expected = expected;
        this.actual = actual;
    }

    public String getMessage() {
        String path;
        if (this.expected == null || this.actual == null) {
            path = SurefireAssert.formatMismatch(super.getMessage(), this.expected, this.actual);
        } else {
            String actual;
            String expected;
            int k;
            int i;
            int end = Math.min(this.expected.length(), this.actual.length());
            for (i = 0; i < end && this.expected.charAt(i) == this.actual.charAt(i); ++i) {
            }
            int j = this.expected.length() - 1;
            for (k = this.actual.length() - 1; k >= i && j >= i && this.expected.charAt(j) == this.actual.charAt(k); --k, --j) {
            }
            if (j < i && k < i) {
                expected = this.expected;
                actual = this.actual;
            } else {
                expected = this.expected.substring(i, j + 1);
                actual = this.actual.substring(i, k + 1);
                if (i <= end && i > 0) {
                    expected = "..." + expected;
                    actual = "..." + actual;
                }
                if (j < this.expected.length() - 1) {
                    expected = expected + "...";
                }
                if (k < this.actual.length() - 1) {
                    actual = actual + "...";
                }
            }
            path = SurefireAssert.formatMismatch(super.getMessage(), expected, actual);
        }
        return path;
    }
}

