/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.lang.reflect.Constructor;
import org.apache.maven.plugin.surefire.report.FileReporterFactory;
import org.apache.maven.surefire.booter.StartupReportConfiguration;
import org.apache.maven.surefire.util.ReflectionUtils;
import org.apache.maven.surefire.util.SurefireReflectionException;

public class CommonReflector {
    private final Class startupReportConfiguration;
    private final ClassLoader surefireClassLoader;

    public CommonReflector(ClassLoader surefireClassLoader) {
        this.surefireClassLoader = surefireClassLoader;
        try {
            this.startupReportConfiguration = surefireClassLoader.loadClass(StartupReportConfiguration.class.getName());
        }
        catch (ClassNotFoundException e) {
            throw new SurefireReflectionException((Throwable)e);
        }
    }

    public Object createReportingReporterFactory(StartupReportConfiguration startupReportConfiguration) {
        Class[] args = new Class[]{this.startupReportConfiguration};
        Object src = this.createStartupReportConfiguration(startupReportConfiguration);
        Object[] params = new Object[]{src};
        return ReflectionUtils.instantiateObject((String)FileReporterFactory.class.getName(), (Class[])args, (Object[])params, (ClassLoader)this.surefireClassLoader);
    }

    Object createStartupReportConfiguration(StartupReportConfiguration reporterConfiguration) {
        Constructor constructor = ReflectionUtils.getConstructor((Class)this.startupReportConfiguration, (Class[])new Class[]{Boolean.TYPE, Boolean.TYPE, String.class, Boolean.TYPE, Boolean.TYPE, File.class, Boolean.TYPE, String.class, String.class, Boolean.TYPE});
        Object[] params = new Object[]{new Boolean(reporterConfiguration.isUseFile()), new Boolean(reporterConfiguration.isPrintSummary()), reporterConfiguration.getReportFormat(), new Boolean(reporterConfiguration.isRedirectTestOutputToFile()), new Boolean(reporterConfiguration.isDisableXmlReport()), reporterConfiguration.getReportsDirectory(), new Boolean(reporterConfiguration.isTrimStackTrace()), reporterConfiguration.getReportNameSuffix(), reporterConfiguration.getConfigurationHash(), reporterConfiguration.isRequiresRunHistory()};
        return ReflectionUtils.newInstance((Constructor)constructor, (Object[])params);
    }
}

