/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.jar.identification.hash;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.jar.JarEntry;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.maven.shared.jar.JarAnalyzer;
import org.apache.maven.shared.jar.JarData;
import org.apache.maven.shared.jar.identification.hash.JarHashAnalyzer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
@Named(value="bytecode")
public class JarBytecodeHashAnalyzer
implements JarHashAnalyzer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public String computeHash(JarAnalyzer jarAnalyzer) {
        JarData jarData = jarAnalyzer.getJarData();
        String result = jarData.getBytecodeHash();
        if (result == null) {
            List<JarEntry> entries = jarAnalyzer.getClassEntries();
            try {
                for (JarEntry entry : entries) {
                    InputStream is = jarAnalyzer.getEntryInputStream(entry);
                    Throwable throwable = null;
                    try {
                        result = DigestUtils.sha1Hex((InputStream)is);
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    finally {
                        if (is == null) continue;
                        if (throwable != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable3) {
                                throwable.addSuppressed(throwable3);
                            }
                            continue;
                        }
                        is.close();
                    }
                }
                jarData.setBytecodeHash(result);
            }
            catch (IOException e) {
                this.logger.warn("Unable to calculate the hashcode.", (Throwable)e);
            }
        }
        return result;
    }
}

