/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg.command.tag;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFile;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.ScmFileStatus;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.tag.AbstractTagCommand;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.HgUtils;
import org.apache.maven.scm.provider.hg.command.HgCommand;
import org.apache.maven.scm.provider.hg.command.HgConsumer;
import org.apache.maven.scm.provider.hg.command.inventory.HgListConsumer;
import org.apache.maven.scm.provider.hg.command.tag.HgTagConsumer;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;
import org.codehaus.plexus.util.StringUtils;

public class HgTagCommand
extends AbstractTagCommand
implements HgCommand {
    protected ScmResult executeTagCommand(ScmProviderRepository scmProviderRepository, ScmFileSet fileSet, String tag, String message) throws ScmException {
        if (tag == null || StringUtils.isEmpty((String)tag.trim())) {
            throw new ScmException("tag must be specified");
        }
        if (fileSet.getFiles().length != 0) {
            throw new ScmException("This provider doesn't support tagging subsets of a directory");
        }
        File workingDir = fileSet.getBasedir();
        String[] tagCmd = new String[]{"tag", "--message", message, tag};
        StringBuffer cmd = this.joinCmd(tagCmd);
        HgTagConsumer consumer = new HgTagConsumer(this.getLogger());
        ScmResult result = HgUtils.execute(consumer, this.getLogger(), workingDir, tagCmd);
        HgScmProviderRepository repository = (HgScmProviderRepository)scmProviderRepository;
        if (result.isSuccess()) {
            if (!repository.getURI().equals(fileSet.getBasedir().getAbsolutePath())) {
                String[] push_cmd = new String[]{"push", repository.getURI()};
                result = HgUtils.execute(new HgConsumer(this.getLogger()), this.getLogger(), fileSet.getBasedir(), push_cmd);
            }
        } else {
            throw new ScmException("Error while executing command " + cmd.toString());
        }
        String[] list_cmd = new String[]{"locate"};
        HgListConsumer listconsumer = new HgListConsumer(this.getLogger());
        result = HgUtils.execute(listconsumer, this.getLogger(), fileSet.getBasedir(), list_cmd);
        if (result.isSuccess()) {
            List files = listconsumer.getFiles();
            ArrayList<ScmFile> fileList = new ArrayList<ScmFile>();
            Iterator i = files.iterator();
            while (i.hasNext()) {
                ScmFile f = (ScmFile)i.next();
                if (f.getPath().endsWith(".hgtags")) continue;
                fileList.add(new ScmFile(f.getPath(), ScmFileStatus.TAGGED));
            }
            return new TagScmResult(fileList, result);
        }
        throw new ScmException("Error while executing command " + cmd.toString());
    }

    private StringBuffer joinCmd(String[] cmd) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < cmd.length; ++i) {
            String s = cmd[i];
            result.append(s);
            if (i >= cmd.length - 1) continue;
            result.append(" ");
        }
        return result;
    }
}

