/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.provider.hg;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmFileSet;
import org.apache.maven.scm.command.add.AddScmResult;
import org.apache.maven.scm.command.changelog.ChangeLogScmResult;
import org.apache.maven.scm.command.checkin.CheckInScmResult;
import org.apache.maven.scm.command.checkout.CheckOutScmResult;
import org.apache.maven.scm.command.diff.DiffScmResult;
import org.apache.maven.scm.command.remove.RemoveScmResult;
import org.apache.maven.scm.command.status.StatusScmResult;
import org.apache.maven.scm.command.tag.TagScmResult;
import org.apache.maven.scm.command.update.UpdateScmResult;
import org.apache.maven.scm.provider.AbstractScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.hg.command.add.HgAddCommand;
import org.apache.maven.scm.provider.hg.command.changelog.HgChangeLogCommand;
import org.apache.maven.scm.provider.hg.command.checkin.HgCheckInCommand;
import org.apache.maven.scm.provider.hg.command.checkout.HgCheckOutCommand;
import org.apache.maven.scm.provider.hg.command.diff.HgDiffCommand;
import org.apache.maven.scm.provider.hg.command.remove.HgRemoveCommand;
import org.apache.maven.scm.provider.hg.command.status.HgStatusCommand;
import org.apache.maven.scm.provider.hg.command.tag.HgTagCommand;
import org.apache.maven.scm.provider.hg.command.update.HgUpdateCommand;
import org.apache.maven.scm.provider.hg.repository.HgScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.scm.repository.UnknownRepositoryStructure;

public class HgScmProvider
extends AbstractScmProvider {
    public String getScmSpecificFilename() {
        return ".hg";
    }

    public ScmProviderRepository makeProviderScmRepository(String scmSpecificUrl, char delimiter) throws ScmRepositoryException {
        HgUrlParserResult result = this.parseScmUrl(scmSpecificUrl);
        if (result.messages.size() > 0) {
            throw new ScmRepositoryException("The scm url is invalid.", result.messages);
        }
        return result.repository;
    }

    private HgUrlParserResult parseScmUrl(String scmSpecificUrl) {
        HgUrlParserResult result = new HgUrlParserResult();
        String url = scmSpecificUrl;
        if (url.startsWith("file")) {
            if (!url.startsWith("file:///") && !url.startsWith("file://localhost/")) {
                result.messages.add("An hg 'file' url must be on the form 'file:///' or 'file://localhost/'.");
                return result;
            }
        } else if (url.startsWith("https")) {
            if (!url.startsWith("https://")) {
                result.messages.add("An hg 'http' url must be on the form 'https://'.");
                return result;
            }
        } else if (url.startsWith("http")) {
            if (!url.startsWith("http://")) {
                result.messages.add("An hg 'http' url must be on the form 'http://'.");
                return result;
            }
        } else {
            try {
                File file = new File(url);
            }
            catch (Throwable e) {
                result.messages.add("The filename provided is not valid");
                return result;
            }
        }
        result.repository = new HgScmProviderRepository(url);
        return result;
    }

    public ScmProviderRepository makeProviderScmRepository(File path) throws ScmRepositoryException, UnknownRepositoryStructure {
        if (path == null || !path.isDirectory()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a valid directory.");
        }
        File hgDir = new File(path, ".hg");
        if (!hgDir.exists()) {
            throw new ScmRepositoryException(path.getAbsolutePath() + " isn't a hg directory.");
        }
        return this.makeProviderScmRepository(path.getAbsolutePath(), ':');
    }

    public List validateScmUrl(String scmSpecificUrl, char delimiter) {
        HgUrlParserResult result = this.parseScmUrl(scmSpecificUrl);
        return result.messages;
    }

    public String getScmType() {
        return "hg";
    }

    public AddScmResult add(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgAddCommand command = new HgAddCommand();
        command.setLogger(this.getLogger());
        return (AddScmResult)command.execute(repository, fileSet, parameters);
    }

    public ChangeLogScmResult changelog(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgChangeLogCommand command = new HgChangeLogCommand();
        command.setLogger(this.getLogger());
        return (ChangeLogScmResult)command.execute(repository, fileSet, parameters);
    }

    public CheckInScmResult checkin(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgCheckInCommand command = new HgCheckInCommand();
        command.setLogger(this.getLogger());
        return (CheckInScmResult)command.execute(repository, fileSet, parameters);
    }

    public CheckOutScmResult checkout(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgCheckOutCommand command = new HgCheckOutCommand();
        command.setLogger(this.getLogger());
        return (CheckOutScmResult)command.execute(repository, fileSet, parameters);
    }

    public TagScmResult tag(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgTagCommand command = new HgTagCommand();
        command.setLogger(this.getLogger());
        return (TagScmResult)command.execute(repository, fileSet, parameters);
    }

    public DiffScmResult diff(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgDiffCommand command = new HgDiffCommand();
        command.setLogger(this.getLogger());
        return (DiffScmResult)command.execute(repository, fileSet, parameters);
    }

    public RemoveScmResult remove(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgRemoveCommand command = new HgRemoveCommand();
        command.setLogger(this.getLogger());
        return (RemoveScmResult)command.execute(repository, fileSet, parameters);
    }

    public StatusScmResult status(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgStatusCommand command = new HgStatusCommand();
        command.setLogger(this.getLogger());
        return (StatusScmResult)command.execute(repository, fileSet, parameters);
    }

    public UpdateScmResult update(ScmProviderRepository repository, ScmFileSet fileSet, CommandParameters parameters) throws ScmException {
        HgUpdateCommand command = new HgUpdateCommand();
        command.setLogger(this.getLogger());
        return (UpdateScmResult)command.execute(repository, fileSet, parameters);
    }

    private static class HgUrlParserResult {
        List messages = new ArrayList();
        ScmProviderRepository repository;

        private HgUrlParserResult() {
        }
    }
}

