/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.util;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.xml.XmlStreamReader;

public class ReleaseUtil {
    public static final String RELEASE_POMv4 = "release-pom.xml";
    public static final String POMv4 = "pom.xml";
    private static final char FS = File.separatorChar;
    public static final String LS = System.getProperty("line.separator");

    private ReleaseUtil() {
    }

    public static MavenProject getRootProject(List reactorProjects) {
        MavenProject project = (MavenProject)reactorProjects.get(0);
        Iterator i = reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject currentProject = (MavenProject)i.next();
            if (!currentProject.isExecutionRoot()) continue;
            project = currentProject;
            break;
        }
        return project;
    }

    public static File getStandardPom(MavenProject project) {
        if (project == null) {
            return null;
        }
        File pom = project.getFile();
        if (pom == null) {
            return null;
        }
        File releasePom = ReleaseUtil.getReleasePom(project);
        if (pom.equals(releasePom)) {
            pom = new File(pom.getParent(), POMv4);
        }
        return pom;
    }

    public static File getReleasePom(MavenProject project) {
        if (project == null) {
            return null;
        }
        File pom = project.getFile();
        if (pom == null) {
            return null;
        }
        return new File(pom.getParent(), RELEASE_POMv4);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readXmlFile(File file) throws IOException {
        XmlStreamReader reader = null;
        try {
            reader = ReaderFactory.newXmlReader((File)file);
            String string = ReleaseUtil.normalizeLineEndings(IOUtil.toString((Reader)reader), LS);
            return string;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public static String normalizeLineEndings(String text, String separator) {
        String norm = text;
        if (text != null) {
            norm = text.replaceAll("(\r\n)|(\n)|(\r)", separator);
        }
        return norm;
    }

    public static ReleaseDescriptor createBasedirAlignedReleaseDescriptor(ReleaseDescriptor releaseDescriptor, List reactorProjects) throws ReleaseExecutionException {
        String basedir = ReleaseUtil.getCommonBasedir(reactorProjects);
        int parentLevels = ReleaseUtil.getBaseWorkingDirectoryParentCount(basedir, FileUtils.normalize((String)releaseDescriptor.getWorkingDirectory()));
        String url = releaseDescriptor.getScmSourceUrl();
        url = ReleaseUtil.realignScmUrl(parentLevels, url);
        ReleaseDescriptor descriptor = new ReleaseDescriptor();
        descriptor.setWorkingDirectory(basedir);
        descriptor.setScmSourceUrl(url);
        return descriptor;
    }

    public static String getCommonBasedir(List reactorProjects) {
        return ReleaseUtil.getCommonBasedir(reactorProjects, FS);
    }

    public static String getCommonBasedir(List reactorProjects, char separator) {
        String basedir = null;
        Iterator i = reactorProjects.iterator();
        while (i.hasNext()) {
            MavenProject p = (MavenProject)i.next();
            String dir = FileUtils.normalize((String)p.getBasedir().getPath().replace('\\', '/'));
            if (basedir == null) {
                basedir = dir;
                continue;
            }
            if (!basedir.endsWith("/")) {
                basedir = basedir + "/";
            }
            if ((basedir = StringUtils.getCommonPrefix((String[])new String[]{dir, basedir})).endsWith("/")) continue;
            basedir = basedir.substring(0, basedir.lastIndexOf("/"));
        }
        if (basedir != null) {
            if (basedir.endsWith("/") && basedir.length() > 1) {
                basedir = basedir.substring(0, basedir.length() - 1);
            }
            basedir = basedir.replace('/', separator);
        }
        return basedir;
    }

    public static int getBaseWorkingDirectoryParentCount(String basedir, String workingDirectory) {
        int num = 0;
        if (!workingDirectory.equals(basedir) && workingDirectory.startsWith(basedir)) {
            do {
                workingDirectory = new File(workingDirectory).getParent();
                ++num;
            } while (workingDirectory.length() > basedir.length());
        }
        return num;
    }

    public static String realignScmUrl(int parentLevels, String url) {
        if (!StringUtils.isEmpty((String)url)) {
            int index = url.length();
            String suffix = "";
            if (url.endsWith("/")) {
                --index;
                suffix = "/";
            }
            for (int i = 0; i < parentLevels && index > 0; ++i) {
                index = url.lastIndexOf(47, index - 1);
            }
            if (index > 0) {
                url = url.substring(0, index) + suffix;
            }
        }
        return url;
    }
}

