/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.scm;

import org.apache.maven.scm.manager.NoSuchScmProviderException;
import org.apache.maven.scm.manager.ScmManager;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.provider.ScmProviderRepository;
import org.apache.maven.scm.provider.ScmProviderRepositoryWithHost;
import org.apache.maven.scm.provider.svn.repository.SvnScmProviderRepository;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.scm.repository.ScmRepositoryException;
import org.apache.maven.settings.Server;
import org.apache.maven.settings.Settings;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.scm.ScmRepositoryConfigurator;
import org.codehaus.plexus.logging.AbstractLogEnabled;
import org.codehaus.plexus.util.StringUtils;

public class DefaultScmRepositoryConfigurator
extends AbstractLogEnabled
implements ScmRepositoryConfigurator {
    private ScmManager scmManager;

    public ScmRepository getConfiguredRepository(ReleaseDescriptor releaseDescriptor, Settings settings) throws ScmRepositoryException, NoSuchScmProviderException {
        ScmProviderRepositoryWithHost repositoryWithHost;
        String username = releaseDescriptor.getScmUsername();
        String password = releaseDescriptor.getScmPassword();
        String url = releaseDescriptor.getScmSourceUrl();
        String privateKey = releaseDescriptor.getScmPrivateKey();
        String passphrase = releaseDescriptor.getScmPrivateKeyPassPhrase();
        ScmRepository repository = this.scmManager.makeScmRepository(url);
        ScmProviderRepository scmRepo = repository.getProviderRepository();
        scmRepo.setPersistCheckout(false);
        if (repository.getProviderRepository() instanceof ScmProviderRepositoryWithHost) {
            Server server;
            repositoryWithHost = (ScmProviderRepositoryWithHost)repository.getProviderRepository();
            String host = repositoryWithHost.getHost();
            int port = repositoryWithHost.getPort();
            if (port > 0) {
                host = host + ":" + port;
            }
            if (settings != null && (server = settings.getServer(host)) != null) {
                if (username == null) {
                    username = server.getUsername();
                }
                if (password == null) {
                    password = server.getPassword();
                }
                if (privateKey == null) {
                    privateKey = server.getPrivateKey();
                }
                if (passphrase == null) {
                    passphrase = server.getPassphrase();
                }
            }
        }
        if (!StringUtils.isEmpty((String)username)) {
            scmRepo.setUser(username);
        }
        if (!StringUtils.isEmpty((String)password)) {
            scmRepo.setPassword(password);
        }
        if (scmRepo instanceof ScmProviderRepositoryWithHost) {
            repositoryWithHost = (ScmProviderRepositoryWithHost)scmRepo;
            if (!StringUtils.isEmpty((String)privateKey)) {
                repositoryWithHost.setPrivateKey(privateKey);
            }
            if (!StringUtils.isEmpty((String)passphrase)) {
                repositoryWithHost.setPassphrase(passphrase);
            }
        }
        if ("svn".equals(repository.getProvider())) {
            SvnScmProviderRepository svnRepo = (SvnScmProviderRepository)repository.getProviderRepository();
            String tagBase = releaseDescriptor.getScmTagBase();
            if (!StringUtils.isEmpty((String)tagBase)) {
                svnRepo.setTagBase(tagBase);
            }
        }
        return repository;
    }

    public ScmProvider getRepositoryProvider(ScmRepository repository) throws NoSuchScmProviderException {
        return this.scmManager.getProviderByRepository(repository);
    }

    public void setScmManager(ScmManager scmManager) {
        this.scmManager = scmManager;
    }
}

