/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.release.phase;

import java.util.List;
import java.util.Map;
import org.apache.maven.model.Scm;
import org.apache.maven.project.MavenProject;
import org.apache.maven.scm.repository.ScmRepository;
import org.apache.maven.shared.release.ReleaseExecutionException;
import org.apache.maven.shared.release.ReleaseResult;
import org.apache.maven.shared.release.config.ReleaseDescriptor;
import org.apache.maven.shared.release.phase.AbstractRewritePomsPhase;
import org.apache.maven.shared.release.scm.ScmTranslator;
import org.jdom.Element;
import org.jdom.Namespace;

public class RewritePomsForDevelopmentPhase
extends AbstractRewritePomsPhase {
    private Map scmTranslators;

    protected void transformScm(MavenProject project, Element rootElement, Namespace namespace, ReleaseDescriptor releaseDescriptor, String projectId, ScmRepository scmRepository, ReleaseResult result, MavenProject rootProject) throws ReleaseExecutionException {
        Element scmRoot;
        if (project.getScm() != null && (scmRoot = rootElement.getChild("scm", namespace)) != null) {
            Map originalScmInfo = releaseDescriptor.getOriginalScmInfo();
            if (!originalScmInfo.containsKey(projectId)) {
                throw new ReleaseExecutionException("Unable to find original SCM info for '" + project.getName() + "'");
            }
            ScmTranslator translator = (ScmTranslator)this.scmTranslators.get(scmRepository.getProvider());
            if (translator != null) {
                Scm scm = (Scm)originalScmInfo.get(projectId);
                if (scm != null) {
                    this.rewriteElement("connection", scm.getConnection(), scmRoot, namespace);
                    this.rewriteElement("developerConnection", scm.getDeveloperConnection(), scmRoot, namespace);
                    this.rewriteElement("url", scm.getUrl(), scmRoot, namespace);
                    this.rewriteElement("tag", translator.resolveTag(scm.getTag()), scmRoot, namespace);
                } else {
                    this.rewriteElement("scm", null, rootElement, namespace);
                }
            } else {
                String message = "No SCM translator found - skipping rewrite";
                result.appendDebug(message);
                this.getLogger().debug(message);
            }
        }
    }

    protected Map getOriginalVersionMap(ReleaseDescriptor releaseDescriptor, List reactorProjects) {
        return releaseDescriptor.getReleaseVersions();
    }

    protected Map getNextVersionMap(ReleaseDescriptor releaseDescriptor) {
        return releaseDescriptor.getDevelopmentVersions();
    }

    protected String getResolvedSnapshotVersion(String artifactVersionlessKey, Map resolvedSnapshotsMap) {
        Map versionsMap = (Map)resolvedSnapshotsMap.get(artifactVersionlessKey);
        if (versionsMap != null) {
            return (String)versionsMap.get("dev");
        }
        return null;
    }
}

