/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.apache.maven.model.ReportPlugin;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.surefire.report.LocalizedProperties;
import org.apache.maven.plugins.surefire.report.PluginConsoleLogger;
import org.apache.maven.plugins.surefire.report.SurefireReportGenerator;
import org.apache.maven.plugins.surefire.report.SurefireReportParser;
import org.apache.maven.project.MavenProject;
import org.apache.maven.reporting.AbstractMavenReport;
import org.apache.maven.reporting.MavenReportException;
import org.apache.maven.shared.utils.PathTool;
import org.apache.maven.shared.utils.StringUtils;

public abstract class AbstractSurefireReportMojo
extends AbstractMavenReport {
    @Parameter(defaultValue="true", required=true, property="showSuccess")
    private boolean showSuccess;
    @Parameter
    private File[] reportsDirectories;
    @Deprecated
    @Parameter
    private File reportsDirectory;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(defaultValue="${project.reporting.outputDirectory}/xref-test")
    private File xrefLocation;
    @Parameter(defaultValue="true", property="linkXRef")
    private boolean linkXRef;
    @Parameter(defaultValue="false", property="aggregate")
    private boolean aggregate;
    private List<File> resolvedReportsDirectories;

    protected boolean isSkipped() {
        return false;
    }

    protected boolean isGeneratedWhenNoResults() {
        return false;
    }

    public abstract void setTitle(String var1);

    public abstract String getTitle();

    public abstract void setDescription(String var1);

    public abstract String getDescription();

    public void executeReport(Locale locale) throws MavenReportException {
        if (!this.hasReportDirectories()) {
            return;
        }
        new SurefireReportGenerator(this.getReportsDirectories(), locale, this.showSuccess, this.determineXrefLocation(), this.getConsoleLogger()).doGenerateReport(this.getBundle(locale), this.getSink());
    }

    public boolean canGenerateReport() {
        return this.hasReportDirectories() && super.canGenerateReport();
    }

    private boolean hasReportDirectories() {
        if (this.isSkipped()) {
            return false;
        }
        List<File> reportsDirectories = this.getReportsDirectories();
        if (reportsDirectories == null) {
            return false;
        }
        if (!this.isGeneratedWhenNoResults()) {
            boolean atLeastOneDirectoryExists = false;
            Iterator<File> i = reportsDirectories.iterator();
            while (i.hasNext() && !atLeastOneDirectoryExists) {
                atLeastOneDirectoryExists = SurefireReportParser.hasReportFiles((File)i.next());
            }
            if (!atLeastOneDirectoryExists) {
                return false;
            }
        }
        return true;
    }

    private List<File> getReportsDirectories() {
        if (this.resolvedReportsDirectories != null) {
            return this.resolvedReportsDirectories;
        }
        this.resolvedReportsDirectories = new ArrayList<File>();
        if (this.reportsDirectories != null) {
            Collections.addAll(this.resolvedReportsDirectories, this.reportsDirectories);
        }
        if (this.reportsDirectory != null) {
            this.resolvedReportsDirectories.add(this.reportsDirectory);
        }
        if (this.aggregate) {
            if (!this.project.isExecutionRoot()) {
                return null;
            }
            if (this.reportsDirectories == null) {
                for (MavenProject mavenProject : this.getProjectsWithoutRoot()) {
                    this.resolvedReportsDirectories.add(this.getSurefireReportsDirectory(mavenProject));
                }
            } else {
                String parentBaseDir = this.getProject().getBasedir().getAbsolutePath();
                for (MavenProject subProject : this.getProjectsWithoutRoot()) {
                    String moduleBaseDir = subProject.getBasedir().getAbsolutePath();
                    for (File reportsDirectory1 : this.reportsDirectories) {
                        File reportsDirectory;
                        String reportDir = reportsDirectory1.getPath();
                        if (reportDir.startsWith(parentBaseDir)) {
                            reportDir = reportDir.substring(parentBaseDir.length());
                        }
                        if (!(reportsDirectory = new File(moduleBaseDir, reportDir)).exists() || !reportsDirectory.isDirectory()) continue;
                        this.getConsoleLogger().debug("Adding report dir : " + moduleBaseDir + reportDir);
                        this.resolvedReportsDirectories.add(reportsDirectory);
                    }
                }
            }
        } else if (this.resolvedReportsDirectories.isEmpty()) {
            this.resolvedReportsDirectories.add(this.getSurefireReportsDirectory(this.project));
        }
        return this.resolvedReportsDirectories;
    }

    protected abstract File getSurefireReportsDirectory(MavenProject var1);

    private List<MavenProject> getProjectsWithoutRoot() {
        ArrayList<MavenProject> result = new ArrayList<MavenProject>();
        for (MavenProject subProject : this.reactorProjects) {
            if (this.project.equals((Object)subProject)) continue;
            result.add(subProject);
        }
        return result;
    }

    private String determineXrefLocation() {
        String location = null;
        if (this.linkXRef) {
            String relativePath = PathTool.getRelativePath((String)this.getOutputDirectory(), (String)this.xrefLocation.getAbsolutePath());
            if (StringUtils.isEmpty((String)relativePath)) {
                relativePath = ".";
            }
            relativePath = relativePath + "/" + this.xrefLocation.getName();
            if (this.xrefLocation.exists()) {
                location = relativePath;
            } else {
                for (Object o : this.project.getReportPlugins()) {
                    ReportPlugin report = (ReportPlugin)o;
                    String artifactId = report.getArtifactId();
                    if (!"maven-jxr-plugin".equals(artifactId) && !"jxr-maven-plugin".equals(artifactId)) continue;
                    location = relativePath;
                }
            }
            if (location == null) {
                this.getConsoleLogger().warning("Unable to locate Test Source XRef to link to - DISABLED");
            }
        }
        return location;
    }

    public String getName(Locale locale) {
        return this.getBundle(locale).getReportName();
    }

    public String getDescription(Locale locale) {
        return this.getBundle(locale).getReportDescription();
    }

    public abstract String getOutputName();

    protected abstract LocalizedProperties getBundle(Locale var1, ClassLoader var2);

    protected final ConsoleLogger getConsoleLogger() {
        return new PluginConsoleLogger(this.getLog());
    }

    final LocalizedProperties getBundle(Locale locale) {
        return this.getBundle(locale, ((Object)((Object)this)).getClass().getClassLoader());
    }
}

