/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugins.surefire.report;

import org.apache.maven.plugin.logging.Log;
import org.apache.maven.plugin.surefire.log.api.ConsoleLogger;
import org.apache.maven.shared.utils.logging.MessageBuilder;
import org.apache.maven.shared.utils.logging.MessageUtils;

final class PluginConsoleLogger
implements ConsoleLogger {
    private final Log mojoLogger;

    PluginConsoleLogger(Log mojoLogger) {
        this.mojoLogger = mojoLogger;
    }

    public boolean isDebugEnabled() {
        return this.mojoLogger.isDebugEnabled();
    }

    public void debug(String message) {
        if (this.mojoLogger.isDebugEnabled()) {
            this.mojoLogger.debug((CharSequence)PluginConsoleLogger.createAnsiBuilder(message).debug(message).toString());
        }
    }

    public void debug(CharSequence content, Throwable error) {
        if (this.mojoLogger.isDebugEnabled()) {
            this.mojoLogger.debug(content, error);
        }
    }

    public boolean isInfoEnabled() {
        return this.mojoLogger.isInfoEnabled();
    }

    public void info(String message) {
        if (this.mojoLogger.isInfoEnabled()) {
            this.mojoLogger.info((CharSequence)PluginConsoleLogger.createAnsiBuilder(message).info(message).toString());
        }
    }

    public boolean isWarnEnabled() {
        return this.mojoLogger.isWarnEnabled();
    }

    public void warning(String message) {
        if (this.mojoLogger.isWarnEnabled()) {
            this.mojoLogger.warn((CharSequence)PluginConsoleLogger.createAnsiBuilder(message).warning(message).toString());
        }
    }

    public void warn(CharSequence content, Throwable error) {
        if (this.mojoLogger.isWarnEnabled()) {
            this.mojoLogger.warn(content, error);
        }
    }

    public boolean isErrorEnabled() {
        return this.mojoLogger.isErrorEnabled();
    }

    public void error(String message) {
        if (this.mojoLogger.isErrorEnabled()) {
            this.mojoLogger.error((CharSequence)PluginConsoleLogger.createAnsiBuilder(message).error(message).toString());
        }
    }

    public void error(String message, Throwable t) {
        if (this.mojoLogger.isErrorEnabled()) {
            this.mojoLogger.error((CharSequence)message, t);
        }
    }

    public void error(Throwable t) {
        if (this.mojoLogger.isErrorEnabled()) {
            this.mojoLogger.error(t);
        }
    }

    private static MessageBuilder createAnsiBuilder(CharSequence message) {
        return MessageUtils.buffer(PluginConsoleLogger.bufferSize(message));
    }

    private static int bufferSize(CharSequence message) {
        return 32 - Integer.numberOfLeadingZeros(message.length());
    }
}

