/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.scm.plugin;

import java.io.IOException;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.scm.CommandParameter;
import org.apache.maven.scm.CommandParameters;
import org.apache.maven.scm.ScmException;
import org.apache.maven.scm.ScmResult;
import org.apache.maven.scm.command.untag.UntagScmResult;
import org.apache.maven.scm.plugin.AbstractScmMojo;
import org.apache.maven.scm.provider.ScmProvider;
import org.apache.maven.scm.repository.ScmRepository;

@Mojo(name="untag", aggregator=true)
public class UntagMojo
extends AbstractScmMojo {
    @Parameter(property="tag", required=true)
    private String tag;
    @Parameter(property="message", required=false)
    private String message;

    @Override
    public void execute() throws MojoExecutionException {
        super.execute();
        try {
            ScmRepository repository = this.getScmRepository();
            ScmProvider provider = this.getScmManager().getProviderByRepository(repository);
            String finalTag = provider.sanitizeTagName(this.tag);
            this.getLog().info((CharSequence)("Final Tag Name: '" + finalTag + "'"));
            CommandParameters parameters = new CommandParameters();
            parameters.setString(CommandParameter.TAG_NAME, finalTag);
            parameters.setString(CommandParameter.MESSAGE, this.message);
            UntagScmResult result = provider.untag(repository, this.getFileSet(), parameters);
            this.checkResult((ScmResult)result);
        }
        catch (IOException | ScmException e) {
            throw new MojoExecutionException("Cannot run untag command", (Exception)e);
        }
    }
}

