/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.report.projectinfo.dependencies;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.maven.model.Dependency;

public class ManagementDependencies {
    private final List managementDependencies;

    public ManagementDependencies(List projectDependencies) {
        this.managementDependencies = projectDependencies;
    }

    public boolean hasDependencies() {
        return this.managementDependencies != null && !this.managementDependencies.isEmpty();
    }

    public List getManagementDependencies() {
        return new ArrayList(this.managementDependencies);
    }

    public Map getManagementDependenciesByScope() {
        HashMap<String, ArrayList<Dependency>> dependenciesByScope = new HashMap<String, ArrayList<Dependency>>();
        Iterator i = this.getManagementDependencies().iterator();
        while (i.hasNext()) {
            Dependency dependency = (Dependency)i.next();
            String scope = dependency.getScope() != null ? dependency.getScope() : "compile";
            ArrayList<Dependency> multiValue = (ArrayList<Dependency>)dependenciesByScope.get(scope);
            if (multiValue == null) {
                multiValue = new ArrayList<Dependency>();
            }
            multiValue.add(dependency);
            dependenciesByScope.put(scope, multiValue);
        }
        return dependenciesByScope;
    }
}

